/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SyncUtils.java 1882 2005-05-17 16:41:07Z jmettraux $
 */

//
// SyncUtils.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.expressions.sync;

import openwfe.org.ApplicationContext;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.map.ExpressionMap;


/**
 * Some methods to use with SyncExpression classes
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: SyncUtils.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public abstract class SyncUtils
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(SyncUtils.class.getName());

    //
    // CONSTANTS & co

    /**
     * This constant is used as an attributeName for expressions implementing
     * SynchableExpression. They can thus tell which SyncExpression they will
     * use.
     */
    public final static String SYNC
        = "sync";

    /* * 
     * The default sync expression is 'last-wins'
     * /
    public final static Class DEFAULT_SYNC_EXPRESSION_CLASS
        = openwfe.org.engine.expressions.sync.LastWinsSyncExpression.class;
     */

    //
    // METHODS

    /**
     * This method is called upon building a concurrent flow expression : the
     * attributes of the concurrent expression are read to determine which
     * sync expression should get instantiated and how it should be used.
     */
    public static SyncExpression determineSyncExpression
        (final SynchableExpression synchableExpression,
         final java.util.List childList,
         final InFlowWorkItem wi)
    throws 
        ApplyException
    {
        if (synchableExpression.context() == null)
        {
            log.debug
                ("determineSyncExpression() context is null, returning null");
            return null;
        }

        try
        {
            //final String syncName = (String)expressionAttributes.get(SYNC);

            final String syncName = ((FlowExpression)synchableExpression)
                .lookupAttribute(SYNC, wi);

            if (syncName == null) 
            {
                log.debug("Returning default SyncExpression");

                final SyncExpression result = new GenericSyncExpression();

                result.init(synchableExpression, childList, wi);

                return result;
            }

            log.debug("syncExpressionName : '"+syncName+"'");
            //log.debug("context is null ? "+(context == null));

            final ExpressionMap expMap = Definitions
                .getExpressionMap(synchableExpression.context());

            final Class syncClass = expMap.getClass(syncName);

            log.debug
                ("Returning syncExpression of class '"+syncClass.getName()+"'");

            final SyncExpression result = 
                (SyncExpression)syncClass.newInstance();

            result.init(synchableExpression, childList, wi);

            return result;
        }
        catch (final Exception e)
        {
            throw new ApplyException
                ("Failed to determine sync expression", e);
        }
    }

}
