/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: CadrExpression.java 2213 2005-10-30 21:33:59Z jmettraux $
 */

//
// CadrExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions.xeme;

import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.WithChildren;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;


/**
 * car/cdr implementation.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: CadrExpression.java 2213 2005-10-30 21:33:59Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class CadrExpression

    extends XemeExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(CadrExpression.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        log.debug("apply() children : "+this.getChildren().size());

        if (this.getChildren().size() < 1)
        {
            applyWithRawValue(wi);
            return;
        }

        final FlowExpressionId fei = (FlowExpressionId)getChildren().get(0);

        getExpressionPool().apply(fei, wi);
    }

    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        execute(wi, XemeUtils.fetchWorkitemResult(this, wi));

        replyToParent(wi);
    }

    //
    // METHODS

    /**
     * As the expression has no children, it's perhaps holding some
     * raw XML, let's try to handle that one.
     */
    protected void applyWithRawValue (final InFlowWorkItem wi)
        throws ApplyException
    {
        final String s1 = lookupAttribute(A_CONTENT, wi);
        final String s2 = lookupAttribute(A_VALUE, wi);

        String sXml = s1;
        if (sXml == null) sXml = s2;

        log.debug("applyWithRawValue() sXml (0) \n"+sXml);

        if (sXml == null)
        {
            ValueUtils.cleanResult(wi);
        }
        else
        {
            //sXml = XmlUtils.removeHeaderLine(sXml);

            log.debug("applyWithRawValue() sXml (1) \n"+sXml);

            org.jdom.Content con = null;

            try
            {
                con = XmlUtils.extractXmlElement(sXml);
            }
            catch (final Exception e)
            {
                throw new ApplyException
                    ("Failed to extract embedded XML", e);
            }

            execute(wi, con);
        }

        applyToParent(wi);
            //
            // thus reply will never get called
    }

    /**
     * Does the job of executing the car or cdr commands (xdr or xar too).
     */
    protected void execute 
        (final InFlowWorkItem wi, 
         org.jdom.Content con)
    {
        String command = this.getId().getExpressionName();

        log.debug("execute() full command >"+command+"<");

        final char com = command.charAt(0);
        command = command.substring(1, command.length()-1);

        if (com == 'x')
        {
            con = xExecute(command, con);
        }
        else if (com == 'c')
        {
            con = cExecute(command, con);
        }
        else
        {
            throw new IllegalArgumentException
                ("not a valid command '"+command+"'");
        }

        ValueUtils.setResult(wi, new XmlAttribute(con));
    }

    /**
     * Does the job of calling XemeUtils.car(xml) or .cdr(xml) (recursively).
     */
    protected org.jdom.Content cExecute 
        (final String command, final org.jdom.Content con)
    {
        log.debug("cExecute() command >"+command+"<");
        log.debug("cExecute() con is (0) \n"+XmlUtils.xmlToString(con));
        log.debug("cExecute() con is of class  "+con.getClass().getName());

        if (command.length() < 1) return con;

        final char c = command.charAt(command.length()-1);

        log.debug("execute() c is '"+c+"'");

        org.jdom.Content content = null;

        if (c == 'a')
            content = XemeUtils.car(con);
        else
            content = XemeUtils.cdr(con);

        log.debug("cExecute() con is (1) \n"+XmlUtils.xmlToString(content));

        return cExecute(command.substring(0, command.length()-1), content);
    }

    /**
     * Does the job of calling XemeUtils.xar(xml) or .xdr(xml) (recursively).
     */
    protected org.jdom.Content xExecute 
        (final String command, final org.jdom.Content con)
    {
        //log.debug("execute() command >"+command+"<");
        //log.debug("execute() con is (0) \n"+XmlUtils.toString(con));

        if (command.length() < 1) return con;

        final char c = command.charAt(command.length()-1);

        //log.debug("execute() c is '"+c+"'");

        org.jdom.Content content = null;

        if (c == 'a')
            content = XemeUtils.xar(con);
        else
            content = XemeUtils.xdr(con);

        //log.debug("execute() con is (1) \n"+XmlUtils.toString(content));

        //return xExecute(command.substring(0, command.length()-1), content);
        return content;
    }

    //
    // STATIC METHODS

}
