/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ListExpression.java 2213 2005-10-30 21:33:59Z jmettraux $
 */

//
// ListExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions.xeme;

import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.WithChildren;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.AbstractCompositeFlowExpression;


/**
 * Gathers element to build a list
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ListExpression.java 2213 2005-10-30 21:33:59Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ListExpression

    extends AbstractCompositeFlowExpression

    implements WithChildren

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ListExpression.class.getName());

    //
    // CONSTANTS & co

    public final static String A_SEP = "sep";

    public final static String DEFAULT_SEP = ",\\s*";


    /**
     * The empty list as an OpenWFE attribute.
     */
    public final static XmlAttribute EMPTY_LIST
        = new XmlAttribute(new org.jdom.Element("list"));

    //
    // FIELDS

    private String separator = null;

    private java.util.Map childResults = null;

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    public String getSeparator ()
    {
        return this.separator;
    }

    public java.util.Map getChildResults ()
    {
        return this.childResults;
    }

    public void setSeparator (final String s)
    {
        this.separator = s;
    }

    public void setChildResults (final java.util.Map m)
    {
        this.childResults = m;
    }

    //
    // METHODS from FlowExpression

    public synchronized void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        //log.debug("apply() A_CONTENT >"+lookupAttribute(A_CONTENT, wi)+"<");
        //log.debug("apply() A_VALUE >"+lookupAttribute(A_CONTENT, wi)+"<");
            //
            // as it's a dirty (not clean) expression, 
            // these should never be set

        //
        // try to interpret the content as a workitem attribute

        /*
        final String sContent = this.lookupAttribute(A_CONTENT, wi);
        final Attribute a = parseWorkitemAttribute(sContent);

        if (a != null)
        {
            ValueUtils.setResult(wi, a);

            applyToParent(wi);
            return;
        }
        */

        //
        // it's not an attribute, go on

        if (this.getChildren().size() < 1)
        {
            ValueUtils.setResult(wi, EMPTY_LIST);

            applyToParent(wi);
            return;
        }

        this.separator = lookupAttribute(A_SEP, wi, DEFAULT_SEP);

        //
        // do the job

        boolean noChildExpression = true;

        this.childResults = new java.util.HashMap();

        for (int i=0; i<this.getChildren().size(); i++)
        {
            final Object o = this.getChildren().get(i);

            if (o instanceof String)
            {
                final String s = substituteText((String)o, wi);

                this.childResults.put(new Integer(i), s);
            }
            else if (o instanceof FlowExpressionId)
            {
                noChildExpression = false;

                final Integer ii = new Integer(i);

                (new Thread()
                 {
                     public void run ()
                     {
                         final FlowExpressionId fei = 
                             (FlowExpressionId)o;

                         final InFlowWorkItem workitem = 
                             (InFlowWorkItem)wi.clone();

                         try
                         {
                             getExpressionPool().apply(fei, workitem);
                         }
                         catch (final Throwable t)
                         {
                             log.info
                                 ("Failed to apply child", t);

                             ListExpression.this.childResults.put(ii, t);
                         }
                     }
                 }).start();
            }
        }

        if (noChildExpression)
        {
            try
            {
                this.reply(wi);
            }
            catch (final ReplyException e)
            {
                throw new ApplyException("apply failed", e);
            }

            return;
        }

        this.storeItself();
    }

    public synchronized void reply (final InFlowWorkItem wi) 
        throws ReplyException
    {
        log.debug("reply() from "+wi.getLastExpressionId());

        final Attribute result = ValueUtils.getResult(wi);

        final int index = this.getChildren()
            .indexOf(wi.getLastExpressionId());

        if (index > -1)
            this.childResults.put(new Integer(index), result);

        if (this.childResults.size() < this.getChildren().size())
        {
            log.debug
                ("reply() all replies not yet received ("+
                 this.childResults.size()+
                 "/"+this.getChildren().size()+")");
            return;
        }

        if (this.getChildren().size() > 1)
            //
            // compose a list from all the results
        {
            ValueUtils.setResult(wi, newXmlAttribute(this.childResults));

            replyToParent(wi);
            return;
        }

        //
        // else split the resulting (and only) string into a list

        final Object o = this.childResults.get(new Integer(0));

        final String[] ss = o.toString().split(this.separator);

        ValueUtils.setResult(wi, newXmlAttribute(ss));

        replyToParent(wi);
    }

    //
    // METHODS

    private XmlAttribute newXmlAttribute (final Object o)
    {
        org.jdom.Content con = new org.jdom.Element("list");

        if (o instanceof String[])
        {
            final String[] ss = (String[])o;

            for (int i=0; i<ss.length; i++)
            {
                final org.jdom.Element e = new org.jdom.Element("string");
                e.addContent(new org.jdom.Text(ss[i]));

                ((org.jdom.Element)con).addContent(e);
            }
        }
        else if (o instanceof java.util.Map)
        {
            final java.util.Map m = (java.util.Map)o;

            for (int i=0; i<m.size(); i++)
            {
                final Integer ii = new Integer(i);

                final Object oo = this.childResults.get(ii);
                
                if (oo instanceof String)
                {
                    ((org.jdom.Element)con).addContent
                        (new org.jdom.Text((String)oo));
                }
                else
                {
                    ((org.jdom.Element)con).addContent
                        (XemeUtils.toXemeResult(this, (Attribute)oo));
                }
            }
        }
        else if (o instanceof Attribute)
        {
            con = XemeUtils.toXemeResult(this, (Attribute)o);
        }

        return new XmlAttribute(con);
    }

    /*
    private Attribute parseWorkitemAttribute (final String sContent)
    {
        try
        {
            org.jdom.Element elt = 
                XmlUtils.extractXmlElement(sContent);

            elt = (org.jdom.Element)elt.getChildren().get(0);

            return Definitions.getXmlCoder
                (this.context()).decodeAttribute(elt);
        }
        catch (final Throwable t)
        {
        }

        log.debug("parseWorkitemAttribute() not a workitem attribute.");

        return null;
    }
    */

    //
    // STATIC METHODS

}
