/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: NChildrenExpression.java 2288 2006-01-16 14:23:48Z jmettraux $
 */

//
// NChildrenExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions.xeme;

import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;


/**
 * car/cdr implementation.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: NChildrenExpression.java 2288 2006-01-16 14:23:48Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class NChildrenExpression

    extends XemeExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(NChildrenExpression.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private java.util.List results = null;

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    /**
     * The results coming from the execution of the children is stored here.
     */
    public java.util.List getResults ()
    {
        return this.results;
    }

    public void setResults (final java.util.List l)
    {
        this.results = l;
    }

    //
    // ABSTRACT METHODS

    /**
     * Extending non abstract class tell by the means of this method
     * how many children they need to execute.
     */
    public abstract int childrenCount ();

    /**
     * This method does the job of turning the children results into the
     * result of the expression itself.
     */
    public abstract org.jdom.Content determineResult ();

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        this.results = new java.util.ArrayList(this.childrenCount());

        if (this.getChildren().size() < childrenCount())
            throw new ApplyException("not enough children");

        final FlowExpressionId fei = (FlowExpressionId)getChildren().get(0);

        getExpressionPool().apply(fei, wi);
    }

    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        log.debug("reply() from  "+wi.getLastExpressionId());

        this.results.add(ValueUtils.getResult(wi));

        if (this.results.size() < this.childrenCount())
            //
            // resume application of children
        {
            final int nextIndex = 
                this.getChildren().indexOf(wi.getLastExpressionId()) + 1;

            log.debug("reply() nextIndex = "+nextIndex);

            final FlowExpressionId fei = 
                (FlowExpressionId)this.getChildren().get(nextIndex);

            try
            {
                getExpressionPool().apply(fei, wi);
            }
            catch (final ApplyException ae)
            {
                throw new ReplyException
                    ("failed to apply next child ("+nextIndex+")", ae);
            }

            return;
        }

        final org.jdom.Content c = determineResult();

        log.debug("reply() result \n"+XmlUtils.xmlToString(c));

        ValueUtils.setResult(wi, new XmlAttribute(c));

        replyToParent(wi);
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
