/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: NthExpression.java 2257 2005-12-05 17:47:24Z jmettraux $
 */

//
// NthExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions.xeme;

import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;


/**
 * car/cdr implementation.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: NthExpression.java 2257 2005-12-05 17:47:24Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class NthExpression

    extends NChildrenExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(NthExpression.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    //
    // METHODS from FlowExpression

    //
    // METHODS from NChildrenExpression

    /**
     * Extending non abstract class tell by the means of this method
     * how many children they need to execute.
     */
    public int childrenCount ()
    {
        return 2;
    }

    /**
     * This method does the job of turning the children results into the
     * result of the expression itself.
     */
    public org.jdom.Content determineResult ()
    {
        final Attribute a0 = (Attribute)getResults().get(0);
        final Attribute a1 = (Attribute)getResults().get(1);

        final int index = AttributeUtils.toInt(this.context(), a0);
        final org.jdom.Content c = XemeUtils.toXemeResult(this, a1);

        log.debug
            ("determineResult nth ("+index+") of "+XmlUtils.xmlToString(c));

        return XemeUtils.nth(index, c);
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
