/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: TwoChildrenExpression.java 2313 2006-01-27 15:16:21Z jmettraux $
 */

//
// TwoChildrenExpression.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.expressions.xeme;

import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;


/**
 * An abstract base for the implementation of 'cons', 'xons' and 'append'.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: TwoChildrenExpression.java 2313 2006-01-27 15:16:21Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class TwoChildrenExpression

    extends XemeExpression

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(TwoChildrenExpression.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private Attribute firstChildResult = null;

    //
    // CONSTRUCTORS

    //
    // BEAN METHODS

    public Attribute getFirstChildResult ()
    {
        return this.firstChildResult;
    }

    public void setFirstChildResult (final Attribute a)
    {
        this.firstChildResult = a;
    }

    //
    // METHODS from FlowExpression

    public void apply (final InFlowWorkItem wi)
        throws ApplyException
    {
        if (getChildren().size() < 2)
        {
            throw new ApplyException
                ("'cons' and 'xons' must have 2 children. "+
                 getChildren().size()+" found.");
        }

        final FlowExpressionId fei = (FlowExpressionId)getChildren().get(0);

        getExpressionPool().apply(fei, wi);
    }

    public void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        final FlowExpressionId firstChildFei = 
            (FlowExpressionId)getChildren().get(0);

        final FlowExpressionId incomingFei = wi.getLastExpressionId();

        if (incomingFei.equals(firstChildFei))
        {
            //
            // keep result

            this.firstChildResult = ValueUtils.getResult(wi);

            if (this.firstChildResult != null)
            {
                this.firstChildResult = 
                    (Attribute)this.firstChildResult.clone();
            }

            //
            // apply second child

            final FlowExpressionId next = 
                (FlowExpressionId)getChildren().get(1);

            //ValueUtils.cleanResult(wi);

            try
            {
                getExpressionPool().apply(next, wi);
            }
            catch (final ApplyException e)
            {
                throw new ReplyException
                    ("Failed to apply second child", e);
            }

            this.storeItself();

            return;
        }

        //
        // then the second child replied

        org.jdom.Content c0 = null;

        if (this.firstChildResult instanceof StringAttribute)
            c0 = new org.jdom.Text(this.firstChildResult.toString());
        else
            c0 = XemeUtils.toXemeResult(this, this.firstChildResult);

        final org.jdom.Content c1 = XemeUtils.fetchWorkitemResult(this, wi);

        log.debug("reply() c0 is "+XmlUtils.xmlToString(c0));
        log.debug("reply() c1 is "+XmlUtils.xmlToString(c1));

        final org.jdom.Content cResult = computeResult(c0, c1);

        ValueUtils.setResult(wi, new XmlAttribute(cResult));

        replyToParent(wi);
    }

    //
    // ABSTRACT METHODS

    /**
     * The job (cons, xons, append, ...) is done in implementation of
     * this abstract method.
     */
    public abstract org.jdom.Content computeResult 
        (org.jdom.Content c0, org.jdom.Content c1);

    //
    // METHODS

    //
    // STATIC METHODS

}
