/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: History.java 2467 2006-04-12 20:43:44Z jmettraux $
 */

//
// History.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.history;

import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * An interface defining the methods for a history service
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-04-12 22:43:44 +0200 (Wed, 12 Apr 2006) $
 * <br>$Id: History.java 2467 2006-04-12 20:43:44Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public interface History
{

    //
    // some constants

    public final static String EVT_FLOW_START 
        = "+STA";
    public final static String EVT_FLOW_END
        = "+END";
    public final static String EVT_DISPATCH
        = "+DIS";
    public final static String EVT_INCOMING
        = "+INC";

    public final static String EVT_DISPATCH_FAILURE
        = "-dsf";

    public final static String EVT_CANCEL_FLOW
        = "+CNF";
    public final static String EVT_CANCEL_EXPRESSION
        = "+CNX";

    public final static String EVT_GONE_PARENT
        = "+GNE";

    public final static String EVT_DEBUG
        = "-dbg";
    public final static String EVT_INFO
        = "-inf";
    public final static String EVT_WARN
        = "-war";

    //
    // the methods

    /**
     * logs an engine event
     */
    public void log 
        (FlowExpressionId fei, 
         WorkItem wi,
         String eventCode,
         String participantName,
         String message);

    /**
     * returns a HistoryIterator
     */
    public HistoryIterator browse
        (String workflowName,
         String workflowRevision,
         long workflowInstanceId,
         long dateFrom,
         long dateto)
    throws
        HistoryException;

}
