/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ExpoolUtils.java 1903 2005-06-25 08:31:44Z jmettraux $
 */

//
// ExpoolUtils.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.expool;

import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.raw.RawExpression;


/**
 * Utility methods for expression pools and stores.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ExpoolUtils.java 1903 2005-06-25 08:31:44Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class ExpoolUtils
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ExpoolUtils.class.getName());

    //
    // STATIC METHODS

    /**
     * This method is used by content iterators when examining an expression
     * to determine if it should be returned : is the given expression (or raw 
     * expression) assignable from the given class ?
     */
    public static boolean isAssignableFromClass 
        (final FlowExpression fe, final Class expClass)
    {
        //log.debug
        //    ("isAssignableFromClass() is fe null ?       "+(fe == null));
        //log.debug
        //    ("isAssignableFromClass() is expClass null ? "+(expClass == null));

        if (expClass == null) return true;

        Class c = fe.getClass();

        //log.debug("isAssignableFromClass() fe.class is "+c.getName());

        if (fe instanceof RawExpression) 
        {
            //log.debug("isAssignableFromClass() fe is a RawExpression");

            c = ((RawExpression)fe).getExpressionClass();

            //log.debug("isAssignableFromClass() c is "+c);
        }

        //log.debug
        //    ("isAssignableFromClass() expClass : "+expClass.getName()+
        //     "  /  class : "+c.getName());

        return expClass.isAssignableFrom(c);
    }

}
