/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlExpressionStore.java 2385 2006-03-04 09:30:22Z jmettraux $
 */

//
// XmlExpressionStore.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.expool;

import openwfe.org.Utils;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.xml.XmlCoder;
import openwfe.org.time.Time;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ExpressionWithTimeOut;


/**
 * This extension of FileExpressionStore takes care of encoding / decoding
 * expressions as XML beans (by using the class openwfe.org.xml.XmlCoder).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-03-04 10:30:22 +0100 (Sat, 04 Mar 2006) $
 * <br>$Id: XmlExpressionStore.java 2385 2006-03-04 09:30:22Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class XmlExpressionStore

    extends FileExpressionStore

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlExpressionStore.class.getName());
    */

    //
    // CONSTANTS (definitions)

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from FileExpressionStore

    protected void saveExpression 
        (final String fileName, final FlowExpression fe)
    throws 
        Exception
    {
        //final long start = System.currentTimeMillis();

        XmlCoder.save(fileName, fe);

        //log.debug
        //    ("saveExpression() took "+(System.currentTimeMillis() - start));
    }

    protected FlowExpression loadExpression 
        (final String fileName)
    throws 
        Exception
    {
        //final long start = System.currentTimeMillis();

        final FlowExpression result = (FlowExpression)XmlCoder
            .load(Utils.getCanonicalPath
                (getContext().getApplicationDirectory(), fileName));

        result.setApplicationContext(getContext());

        //log.debug
        //    ("loadExpression() took "+(System.currentTimeMillis() - start));

        return result;
    }

    //
    // METHODS from Service

    // 
    // STATIC METHODS

}
