/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: LibraryService.java 2385 2006-03-04 09:30:22Z jmettraux $
 */

//
// SimpleProcessLibrary.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.launch;

import openwfe.org.AbstractService;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.workitem.LaunchItem;


/**
 * A root class for SimpleLibrary and CronService.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: LibraryService.java 2385 2006-03-04 09:30:22Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class LibraryService

    extends AbstractService

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(LibraryService.class.getName());

    //
    // CONSTANTS & co

    /**
     * The 'url' parameter used to indicate to this service which process
     * definitions (the set of libraries) it should launch before the engine 
     * launches any other flow.
     */
    public final static String P_URL
        = "url";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    /**
     * Loads (interprets / launches) a process definition given by its URL.
     * The launch is done synchronously, to ensure that definitions are 
     * interpreted and bound before any further launches.
     */
    protected void load (final String url)
    {
        log.debug("load() url is >"+url+"<");

        try
        {
            final LaunchItem li = new LaunchItem();
            li.setWorkflowDefinitionUrl(url);

            Definitions.getLauncher(this.getContext()).launch(li, false);
                //
                // async is set to false
        }
        catch (final Throwable t)
        {
            log.warn
                ("load() failed to load library at '"+url+"'  "+t);
            log.debug
                ("load() failed to load library at '"+url+"'", t);
        }
    }

    //
    // STATIC METHODS

}
