/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlWorkflowDefinitionValidator.java 1992 2005-08-03 17:03:34Z jmettraux $
 */

//
// XmlWorkflowDefinitionValidator.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.engine.impl.launch;

import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.expressions.map.ExpressionMap;
import openwfe.org.engine.expressions.map.XmlExpressionMap;


/**
 * This class is executable and its purpose is to load a workflow definition
 * from a URL (or simply a path) and to tell if the XML behind the URL 
 * represents a valid Workflow Definition.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: XmlWorkflowDefinitionValidator.java 1992 2005-08-03 17:03:34Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class XmlWorkflowDefinitionValidator
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlWorkflowDefinitionValidator.class.getName());

    //
    // STATIC METHODS

    private static ApplicationContext prepareContext 
        (final String expressionMapPath/*, final String participantMapPath*/)
    throws
        ServiceException
    {
        final ApplicationContext context = new ApplicationContext();

        //
        // prepare expression map

        final XmlExpressionMap em = new XmlExpressionMap();

        java.util.Map params = new java.util.HashMap();
        
        params.put
            (XmlExpressionMap.P_EXPRESSION_MAP_FILE, expressionMapPath);
        
        em.init(Definitions.S_EXPRESSION_MAP, context, params);

        //
        // prepare launcher
        
        final SimpleXmlLauncher launcher = new SimpleXmlLauncher();

        params = new java.util.HashMap();

        launcher.init(Definitions.S_LAUNCHER, context, params);

        //
        // return context
        
        context.put(Definitions.S_EXPRESSION_MAP, em);
        //context.put(Definitions.S_PARTICIPANT_MAP, pm);
        context.put(Definitions.S_LAUNCHER, launcher);

        return context;
    }

    private static void printRealUsage ()
    {
        System.out.println("\nUSAGE :\n");
        System.out.println("  java -cp XXX "+XmlWorkflowDefinitionValidator.class.getName()+" {command_alias} {debug-level} {show-details} {path_to_expression-map} {flowDefinitionURL}\n");
    }

    private static void printUsage (final String command)
    {
        System.out.println("\nUSAGE :\n");
        System.out.println("  "+command+" {flowDefinitionURL} [schema-validation]\n");
        System.out.println("  This command will complain if the given URL points to an invalid");
        System.out.println("  flow definition.");
        System.out.println("  If [schema-validation] is present and set to 'true', XSD schema validation");
        System.out.println("  will occur.\n");
    }

    private static void printCauses 
        (final boolean showDetails, final Throwable t)
    {
        System.out.println("  ! "+t.getClass().getName()+" :");
        System.out.println("    "+t.getMessage());

        if (showDetails)
        {
            System.out.println();
            t.printStackTrace();
            System.out.println();
        }

        if (t.getCause() != null) 
            printCauses(showDetails,t.getCause());
    }

    public static void main (final String[] args)
        throws Exception
    {
        if (args.length < 4)
        {
            printRealUsage();
            return;
        }

        if (args.length < 5)
        {
            printUsage(args[0]);
            return;
        }

        //
        // configure log4j

        org.apache.log4j.BasicConfigurator.configure();

        log.getRootLogger().setLevel(org.apache.log4j.Level
            .toLevel(args[1], org.apache.log4j.Level.INFO));

        //
        // show details ?
        
        boolean showDetails = args[2].equals("true");

        //
        // do the job
        
        System.out.println
            ("\n       --  OpenWFE "+Definitions.OPENWFE_VERSION+"  --");
        
        System.out.println
            ("\n       --- preparing services for validation ---");

        final ApplicationContext context = prepareContext(args[3]);

        final Launcher launcher = (Launcher)Definitions.getLauncher(context);

        if (args.length >= 6)
        {
            String sVal = args[5].toLowerCase();

            if (sVal != null)
            {
                System.setProperty
                    (SimpleXmlLauncher.VALIDATE, sVal);
            }
        }

        System.out.println
            ("\n       - XSD validation set to "+
             SimpleXmlLauncher.shouldValidate()+" -");

        System.out.println
            ("\n       --- initiating validation ---");

        try
        {
            launcher.loadProcessDefinition(args[4]);
        }
        catch (final Throwable t)
        {
            System.out.println
                ("\n       !! "+args[4]+" is NOT valid !!\n");

            //t.printStackTrace();
                // not necessary as the wfibuilder will WARN in case of
                // trouble (with a full stack trace...)
        
            printCauses(showDetails, t);

            System.out.println();

            System.exit(1);

            return;
        }

        System.out.println
            ("\n       == "+args[4]+" is valid ==\n");

        System.exit(0);
    }

}
