/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlParticipantMap.java 2495 2006-04-16 13:44:21Z jmettraux $
 */

//
// XmlParticipantMap.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.participants;

import openwfe.org.Utils;
import openwfe.org.MapUtils;
import openwfe.org.Parameters;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.xconf.XconfBuilder;
import openwfe.org.xconf.XconfElementBuilder;
import openwfe.org.engine.participants.Participant;
import openwfe.org.engine.participants.RefParticipant;
import openwfe.org.engine.participants.LeafParticipant;
import openwfe.org.engine.participants.CompositeParticipant;
import openwfe.org.engine.participants.AbstractParticipantMap;


/**
 * DEPRECATED in favour of a combination of CompositeParticipantMap and 
 * XmlParticipantMapFactory;
 *
 * The standard OpenWFE participant is an XML file listing the participants
 * potentially involved in the processes. 
 * This implementation takes care of locating and parsing this information
 * from a local file or from a URL.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-04-16 15:44:21 +0200 (Sun, 16 Apr 2006) $
 * <br>$Id: XmlParticipantMap.java 2495 2006-04-16 13:44:21Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class XmlParticipantMap

    extends AbstractParticipantMap

    implements XconfElementBuilder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlParticipantMap.class.getName());

    //
    // CONSTANTS (definitions)

    private final static String E_PARTICIPANT
        = "participant";
    private final static String A_NAME
        = "name";
    private final static String A_REGEX
        = "regex";
    private final static String A_REF
        = "ref";
    private final static String A_CLASS
        = "class";

    /**
     * The parameter named 'participantMapFile' indicates to this
     * participant map implementation where it can locate its XML
     * representation.
     * The value of this parameter may be simply the path to a local
     * file or a complete URL. A URL could be shared by many OpenWFE
     * components distributed across an organization and its content
     * be fetched from the intranet server (of course, you can map
     * this scenario to multiple [cross] organizations).
     */
    public final static String P_PARTICIPANT_MAP_FILE
        = "participantMapFile";

    //
    // FIELDS

    private XconfBuilder builder = null;

    //
    // CONSTRUCTORS

    /**
     * Initialization method of this OpenWFE service.
     */
    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        String url = MapUtils.getAsString
            (serviceParams, 
             P_PARTICIPANT_MAP_FILE, 
             "etc/engine/participant-map.xml");

        url = Utils.expandUrl(context.getApplicationDirectory(), url);

        log.debug("init() url is "+url);

        this.builder = new XconfBuilder(url, this);
        this.builder.buildConfig();
    }

    //
    // METHODS from XconfElementBuilder

    /**
     * Clears the participant map. This method should and is only called by
     * the XconfBuilder helper class.
     */
    public void clearConfig ()
    {
        setParticipants(new java.util.ArrayList());
    }

    /**
     * XconfBuilder calls this method when parsing a config file. It should
     * only be used by XconfBuilder.
     */
    public void parseElement 
        (final XconfBuilder builder, final org.jdom.Element elt)
    throws 
        ServiceException
    {
        buildParticipant(elt);
    }

    //
    // METHODS from ParticipantMap

    /**
     * Calls in turn the refreshConfig() method of the inner XconfBuilder.
     */
    public void refreshMap ()
        throws ServiceException
    {
        this.builder.refreshConfig();
    }

    //
    // METHODS from Service

    //
    // METHODS

    /**
     * Turns an xml element into the participant it represents
     */
    protected Participant buildParticipant (final org.jdom.Element elt)
    {
        if ( ! elt.getName().equals(E_PARTICIPANT)) return null;

        String regex = elt.getAttributeValue(A_REGEX);
        if (regex == null) regex = elt.getAttributeValue(A_NAME);

        final java.util.Map params = Parameters.extractParamsAndAttributes(elt);

        log.debug("buildParticipant() building '"+regex+"'");

        if (elt.getChild(E_PARTICIPANT) != null)
        {
            return buildCompositeParticipant(elt, regex, params);
        }

        //
        // determine participant class

        String className = null;

        final String ref = elt.getAttributeValue(A_REF);

        if (ref != null) 
            className = RefParticipant.class.getName();

        final String specifiedClassName = (String)params.get(A_CLASS);

        if (specifiedClassName != null)
            className = specifiedClassName;

        //
        // instantiate participant

        Participant p = null;
        try
        {
            Class participantClass = LeafParticipant.class;

            if (className != null)
                participantClass = Class.forName(className);

            p = (Participant)participantClass.newInstance();
        }
        catch (final Throwable t)
        {
            log.warn
                ("buildParticipant() cannot build from class "+className+
                 ". falling back to "+LeafParticipant.class.getName());
            log.debug
                ("buildParticipant() cannot build from class "+className+
                 ". falling back to "+LeafParticipant.class.getName(),
                 t);

            p = new LeafParticipant();
        }

        log.debug
            ("buildParticipant() of class '"+p.getClass().getName()+"'");

        //p.init(this, regex, params);
        p.init(regex, params);

        this.add(p);

        return p;
    }

    /**
     * Parses a composite participant
     */
    protected CompositeParticipant buildCompositeParticipant 
        (final org.jdom.Element elt,
         final String regex,
         final java.util.Map params)
    {
        final CompositeParticipant cp = new CompositeParticipant();

        cp.init(regex, params);

        this.add(cp);

        final java.util.Iterator it = 
            elt.getChildren(E_PARTICIPANT).iterator();

        while (it.hasNext())
            cp.add(buildParticipant((org.jdom.Element)it.next()));

        return cp;
    }

    //
    // STATUS

    /**
     * Returns the current status of this participant map.
     */
    public org.jdom.Element getStatus ()
    {
        final org.jdom.Element result = new org.jdom.Element(this.getName());

        result.setAttribute
            ("source-url", 
             this.builder.getSourceUrl().toString());

        return result;
    }

}
