/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractWorkItemCoder.java 2030 2005-08-13 08:59:16Z jmettraux $
 */

//
// AbstractWorkItemCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.workitem;

import openwfe.org.time.Time;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.HistoryItem;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.participants.Filter;
import openwfe.org.engine.participants.FilterEntry;


/**
 * half an implementation of a coder
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-08-13 10:59:16 +0200 (Sat, 13 Aug 2005) $
 * <br>$Id: AbstractWorkItemCoder.java 2030 2005-08-13 08:59:16Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class AbstractWorkItemCoder

    implements WorkItemCoder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AbstractWorkItemCoder.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private String name = null;
    private java.util.Map perClassMap = null;
    private ListenerReplyCoder replyCoder = null;

    //
    // CONSTRUCTORS

    public void init
        (final String name,
         final java.util.List attributeCoders,
         final ListenerReplyCoder replyCoder)
    {
        this.name = name;

        perClassMap = new java.util.HashMap(attributeCoders.size());

        java.util.Iterator it = attributeCoders.iterator();
        while (it.hasNext())
        {
            AttributeCoder coder = (AttributeCoder)it.next();
            perClassMap.put(coder.getAttributeClassName(), coder);
        }

        this.replyCoder = replyCoder;
    }

    //
    // METHODS

    public String getName ()
    {
        return this.name;
    }

    /**
     * The returned map allows you to lookup for AttributeCoder instances 
     * given an attribute class.
     */
    public java.util.Map getPerClassMap ()
    {
        return this.perClassMap;
    }

    public ListenerReplyCoder getReplyCoder ()
    {
        return this.replyCoder;
    }

    public AttributeCoder getAttributeCoder (final Attribute a)
        throws CodingException
    {
        //log.debug("getAttributeCoder() for attribute "+a);

        return getAttributeCoder(a.getClass());
    }

    public AttributeCoder getAttributeCoder (final Class attributeClass)
        throws CodingException
    {
        //log.debug("getAttributeCoder() for class "+attributeClass);

        if ( ! Attribute.class.isAssignableFrom(attributeClass))
        {
            throw new CodingException
                ("Class '"+attributeClass.getName()+
                 "' is not an extension of class '"+Attribute.class.getName()+
                 "'");
        }

        //log.debug("getAttributeCoder() this.perClassMap is "+this.perClassMap);

        AttributeCoder result = (AttributeCoder)this.perClassMap
            .get(attributeClass.getName());

        if (result == null)
        {
            throw new CodingException
                ("No coder found for attribute of class '"+
                 attributeClass.getName()+"'");
        }

        return result;
    }

    //
    // STATIC METHODS

}
