/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: MailFormCoder.java 2030 2005-08-13 08:59:16Z jmettraux $
 */

//
// MailFormCoder.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.workitem;

import openwfe.org.Utils;
import openwfe.org.MapUtils;
import openwfe.org.ApplicationContext;
import openwfe.org.misc.Text;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ParticipantExpression;
import openwfe.org.engine.impl.dispatch.MailFormDispatcher;


/**
 * Turns a workitem into a mail message body (and back).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-08-13 10:59:16 +0200 (Sat, 13 Aug 2005) $
 * <br>$Id: MailFormCoder.java 2030 2005-08-13 08:59:16Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class MailFormCoder

    implements WorkItemCoder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MailFormCoder.class.getName());

    //
    // CONSTANTS & co

    private final static String ID_PREFIX = " -- id : ";
    private final static String FIELD_END = " -- X --";

    //
    // FIELDS

    private String name = null;
    private ListenerReplyCoder replyCoder = null;

    //
    // CONSTRUCTORS

    public void init
        (final String name,
         final java.util.List attributeCoders, 
         final ListenerReplyCoder replyCoder)
    {
        this.name = name;

        // ignore the attributeCoders list 
        // (it should be set to null anyway)
        
        this.replyCoder = replyCoder;
    }

    //
    // METHODS

    public String getName ()
    {
        return this.name;
    }

    public ListenerReplyCoder getReplyCoder ()
    {
        return this.replyCoder;
    }

    /**
     * Awaits an input stream, that is read and deserialized into a workitem.
     */
    public WorkItem decode 
        (final Object o,
         final ApplicationContext context,
         final java.util.Map serviceParams) 
    throws 
        CodingException
    {
        java.io.Reader r = null;

        if (o instanceof java.io.Reader)
        {
            r = (java.io.Reader)o;
        }
        else if (o instanceof String)
        {
            r = new java.io.StringReader((String)o);
        }
        else
        {
            throw new CodingException
                ("Cannot decode workitem out of object of class "+
                 o.getClass().getName());
        }

        //
        // do the job

        InFlowWorkItem result = null;

        final java.io.BufferedReader br = new java.io.BufferedReader(r);

        try
        {
            while (true)
            {
                String line = br.readLine();

                if (line == null) break;

                line = removeBracket(line);

                if (result == null)
                {
                    int ip = line.indexOf(ID_PREFIX);

                    if (ip < 0) continue;

                    line = line.substring(ip);

                    String sId = line.substring(ID_PREFIX.length());

                    log.debug("decode() id must be >"+sId+"<");

                    final FlowExpressionId fei = 
                        FlowExpressionId.fromParseableString(sId);

                    result = fetchWorkitem(context, fei);

                    continue;
                }

                if (line.indexOf(FIELD_END) >= 0) break;

                int i = line.indexOf(":");

                if (i < 2) continue;

                String field = line.substring(0, i).trim();

                i = line.indexOf("[");

                String value = line.substring(i+1);

                i = value.lastIndexOf("]");

                if (i > 0) value = value.substring(0, i);

                result.getAttributes().puts(field, value);
            }
        }
        catch (final java.io.IOException e)
        {
            throw new CodingException
                ("Failed to decode mail form workitem", e);
        }
        finally
        {
            try
            {
                br.close();
            }
            catch (final Throwable t)
            {
                // ignore
            }
        }

        return result;
    }

    private String removeBracket (final String in)
    {
        if (in.startsWith(">")) return in.substring(1);
        return in;
    }

    /**
     * Turns the workitem into a byte array (serialized).
     */
    public Object encode 
        (final WorkItem wi, 
         final ApplicationContext context,
         final java.util.Map serviceParams)
    throws 
        CodingException
    {
        //
        // monospace ?

        boolean monospace = true;

        if (serviceParams != null)
        {
            MapUtils.getAsBoolean
                (serviceParams, MailFormDispatcher.P_MONOSPACE, true);
        }

        //
        // let's do the job

        final InFlowWorkItem ifwi = (InFlowWorkItem)wi;

        final StringBuffer result = new StringBuffer();

        //
        // header

        final String sHeader = wi.getAttributes().sget("mf_header");

        if (sHeader != null)
            result.append(sHeader).append("\n");

        //
        // sep

        printSep(result, ifwi);

        //
        // fields

        final String sFields = wi.getAttributes().sget("mf_fields");

        if (sFields != null)
        {
            final String[] fields = sFields.split(", *");

            for (int i=0; i<fields.length; i++)
            {
                final String fieldName = fields[i].trim();

                String field = fieldName + " : ";

                String value = wi.getAttributes().sget(fieldName);
                if (value == null) value = "";

                if (monospace)
                {
                    field = Text.adjust(field, 25, false);
                    //value = Text.adjust(value, 48, true);
                }

                result
                    .append(field)
                    .append("[ ").append(value).append(" ]")
                    .append("\n");
            }
        }

        //
        // sep

        result
            .append("\n")
            .append(FIELD_END)
            .append("\n\n");

        //
        // footer

        final String sFooter = wi.getAttributes().sget("mf_footer");

        if (sFooter != null)
            result.append(sFooter).append("\n");

        //
        // done

        try
        {
            return result.toString().getBytes(Utils.getEncoding());
        }
        catch (final java.io.UnsupportedEncodingException e)
        {
            throw new CodingException
                ("Failed to encode workitem", e);
        }
    }

    /**
     * No implementation needed :  Returns null.
     */
    public AttributeCoder getAttributeCoder (final Attribute a)
    {
        return null;
    }

    /**
     * No implementation needed :  Returns null.
     */
    public AttributeCoder getAttributeCoder (final Class attributeClass)
    {
        return null;
    }

    /**
     * No implementation needed :  Returns null.
     */
    public AttributeCoder getAttributeCoder (final String representation)
    {
        return null;
    }

    //
    // METHODS 

    private void printSep (final StringBuffer sb, final InFlowWorkItem wi)
    {
        sb
            .append("\n")
            .append(ID_PREFIX)
            .append(wi.getLastExpressionId().toParseableString())
            .append("\n\n");
    }

    /**
     * Fetches the applied workitem.
     */
    protected InFlowWorkItem fetchWorkitem 
        (final ApplicationContext context, final FlowExpressionId workitemId)
    {
        final ParticipantExpression pe = 
            (ParticipantExpression)Definitions.getExpressionPool(context)
                .fetch(workitemId);

        return (InFlowWorkItem)pe.getAppliedWorkitem().clone();
    }

    //
    // MAIN

    public static void main (String[] args)
        throws Exception
    {
        //
        // encoding

        InFlowWorkItem wi = new InFlowWorkItem();

        wi.setId(new FlowExpressionId());

        wi.getAttributes().puts("mf_fields", "color, size, quantity");
        wi.getAttributes().puts("mf_header", "This is our offer");
        wi.getAttributes().puts("mf_footer", "Best regards,\n\nJohn");

        wi.getAttributes().puts("color", "blue");
        wi.getAttributes().puts("size", "XL");

        WorkItemCoder coder = new MailFormCoder();

        String s = new String
            ((byte[])coder.encode(wi, null, null), Utils.getEncoding());

        System.out.println(s);

        //
        // decoding

        wi = (InFlowWorkItem)coder
            .decode(new java.io.StringReader(s), null, null);

        System.out.println();

        System.out.println("color    : "+wi.getAttributes().sget("color"));
        System.out.println("size     : "+wi.getAttributes().sget("size"));
        System.out.println("quantity : "+wi.getAttributes().sget("quantity"));
    }

}
