/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: MapAttributeCoder.java 2069 2005-08-21 10:58:24Z jmettraux $
 */

//
// MapAttributeCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.workitem.xml;

import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.MapAttribute;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.WorkItemCoder;


/**
 * Encoding/decoding a map
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-08-21 12:58:24 +0200 (Sun, 21 Aug 2005) $
 * <br>$Id: MapAttributeCoder.java 2069 2005-08-21 10:58:24Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class MapAttributeCoder

    extends AbstractXmlAttributeCoder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MapAttributeCoder.class.getName());

    //
    // CONSTANTS & co

    public final static String ENTRY = "entry";
    public final static String KEY = "key";
    public final static String VALUE = "value";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from AttributeCoder

    public Object encode (final Attribute a, final java.util.Map args)
        throws CodingException
    {
        //
        // one day, the KEY/VALUE should get dropped
        //
        // Sun Aug 21 11:49:54 CEST 2005
        //

        if (a == null) return null;

        MapAttribute ma = (MapAttribute)a;

        org.jdom.Element elt = new org.jdom.Element(getRepresentationName());
        
        java.util.Iterator it = ma.keySet().iterator();
        while (it.hasNext())
        {
            org.jdom.Element entryElt = new org.jdom.Element(ENTRY);
            org.jdom.Element keyElt = new org.jdom.Element(KEY);
            org.jdom.Element valueElt = new org.jdom.Element(VALUE);

            entryElt.addContent(keyElt);
            entryElt.addContent(valueElt);

            Attribute key = (Attribute)it.next();
            AttributeCoder coder = getWorkItemCoder().getAttributeCoder(key);
            keyElt.addContent((org.jdom.Element)coder.encode(key, args));

            Attribute value = ma.get(key);
            coder = getWorkItemCoder().getAttributeCoder(value);
            valueElt.addContent((org.jdom.Element)coder.encode(value, args));

            elt.addContent(entryElt);
        }

        return elt;
    }

    public Attribute decode (final Object o, final java.util.Map args) 
        throws CodingException
    {
        org.jdom.Element elt = WicUtils
            .enforceElement(o, getRepresentationName());

        MapAttribute ma = new MapAttribute();

        fillMap(ma, elt);

        return ma;
    }

    private Attribute decodeElement (final org.jdom.Element elt)
        throws CodingException
    {
        //log.debug ("decodeElement() for elt named '"+elt.getName()+"'");

        final AttributeCoder coder = getXmlWorkItemCoder()
            .getAttributeCoder(elt.getName());

        return coder.decode(elt, null);
    }

    protected void fillMap (final MapAttribute ma, final org.jdom.Element elt)
        throws CodingException
    {
        java.util.Iterator it = elt.getChildren(ENTRY).iterator();
        while (it.hasNext())
        {
            final org.jdom.Element entry = (org.jdom.Element)it.next();

            org.jdom.Element key = entry.getChild(KEY);
            org.jdom.Element value = null;

            if (key == null)
            {
                key = XmlUtils.getChild(entry, 0);
                value = XmlUtils.getChild(entry, 1);
            }
            else
            {
                key = XmlUtils.getFirstChild(key);
                value = entry.getChild(VALUE);
                value = XmlUtils.getFirstChild(value);
            }

            if (key == null || value == null) continue;

            ma.put(decodeElement(key), decodeElement(value));
        }
    }

}
