/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ReplyCoder.java 2180 2005-10-20 12:46:51Z jmettraux $
 */

//
// ReplyCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.workitem.xml;

import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.listen.reply.OkReply;
import openwfe.org.engine.listen.reply.FatalReply;
import openwfe.org.engine.listen.reply.WarningReply;
import openwfe.org.engine.listen.reply.ListenerReply;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;


/**
 * Encoding listener replies.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-10-20 14:46:51 +0200 (Thu, 20 Oct 2005) $
 * <br>$Id: ReplyCoder.java 2180 2005-10-20 12:46:51Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ReplyCoder

    implements ListenerReplyCoder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ReplyCoder.class.getName());

    //
    // CONSTANTS & co

    public final static String OK_REPLY = "ok-reply";
    public final static String WARNING_REPLY = "warning-reply";
    public final static String FATAL_REPLY = "fatal-reply";
    public final static String CANCELLED_REPLY = "cancelled-reply";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from ListenerReplyCoder

    /** 
     * catches and  decodes the reply (if any)
     */
    public ListenerReply decode (Object o)
        throws CodingException
    {
        org.jdom.Element elt = null;

        if (o instanceof org.jdom.Element)
        {
            elt = (org.jdom.Element)o;
        }
        else if (o instanceof java.io.InputStream)
        {
            log.debug("decode() InputStream of class "+o.getClass().getName());

            elt = WicUtils.fetchElementFromStream((java.io.InputStream)o);
        }
        else
        {
            throw new CodingException
                ("Cannot decode instances of class '"+
                 o.getClass().getName()+"'");
        }

        if (elt.getName().equals(OK_REPLY))
        {
            String consumerResult = elt.getAttributeValue("consumer-result");
            return new OkReply(consumerResult);
        }

        String message = 
            elt.getAttributeValue("message");
        String exceptionMessage = 
            elt.getAttributeValue("exceptionMessage");
        String exceptionStackTrace = 
            elt.getAttributeValue("exceptionStackTrace");

        WarningReply reply = null;

        if (elt.getName().equals(WARNING_REPLY))
        {
            reply = new WarningReply();
        }
        else if (elt.getName().equals(FATAL_REPLY))
        {
            reply = new FatalReply();
        }
        else
        {
            throw new CodingException
                ("cannot decode replies named '"+elt.getName()+"'");
        }

        reply.setMessage(message);
        reply.setExceptionMessage(exceptionMessage);
        reply.setExceptionStackTrace(exceptionStackTrace);

        return reply;
    }

    /**
     * Takes care of properly encoding the reply
     */
    public byte[] encode (ListenerReply reply)
        throws CodingException
    {
        org.jdom.Element elt = null;

        try
        {
            if (reply instanceof OkReply)
            {
                return XmlUtils.toByteArray(encode((OkReply)reply));
            }

            if (reply instanceof FatalReply)
            {
                return XmlUtils.toByteArray(encode((FatalReply)reply));
            }

            if (reply instanceof WarningReply)
            {
                return XmlUtils.toByteArray(encode((WarningReply)reply));
            }
        }
        catch (openwfe.org.OpenWfeException owe)
        {
            throw new CodingException
                ("reply encoding failed", owe);
        }

        throw new CodingException
            ("Not able to encode replies of class '"+
             reply.getClass().getName()+"'");
    }

    protected org.jdom.Element encode (OkReply reply)
    {
        org.jdom.Element elt = new org.jdom.Element(OK_REPLY);

        if (reply.getConsumerResult() != null)
        {
            elt.setAttribute
                ("consumer-result", reply.getConsumerResult().toString());
        }

        return elt;
    }

    protected org.jdom.Element encode (WarningReply reply)
    {
        org.jdom.Element elt = new org.jdom.Element(WARNING_REPLY);

        if (reply.getMessage() != null)
        {
            elt.setAttribute
                ("message", reply.getMessage());
        }

        if (reply.getExceptionMessage() != null)
        {
            elt.setAttribute
                ("exceptionMessage", reply.getExceptionMessage());
        }

        if (reply.getExceptionStackTrace() != null)
        {
            elt.addContent
                (reply.getExceptionStackTrace());
        }

        return elt;
    }

    //protected org.jdom.Element encode (CancelledReply reply)
    //{
    //    org.jdom.Element eReply = encode((WarningReply)reply);

    //    eReply.setName(CANCELLED_REPLY);

    //    return eReply;
    //}

    protected org.jdom.Element encode (FatalReply reply)
    {
        org.jdom.Element eReply = encode((WarningReply)reply);

        eReply.setName(FATAL_REPLY);

        return eReply;
    }

}
