/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: StringAttributeCoder.java 2069 2005-08-21 10:58:24Z jmettraux $
 */

//
// StringAttributeCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.workitem.xml;

import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.WorkItemCoder;


/**
 * [en/de]coding string attribute instances.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-08-21 12:58:24 +0200 (Sun, 21 Aug 2005) $
 * <br>$Id: StringAttributeCoder.java 2069 2005-08-21 10:58:24Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class StringAttributeCoder

    extends AbstractXmlAttributeCoder

{

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    //
    // METHODS from AttributeCoder

    public Object encode (final Attribute a, final java.util.Map args)
        throws CodingException
    {
        org.jdom.Element elt = new org.jdom.Element(getRepresentationName());
        elt.addContent((String)((StringAttribute)a).getValue());
        return elt;
    }

    public Attribute decode (final Object o, final java.util.Map args) 
        throws CodingException
    {
        org.jdom.Element elt = WicUtils
            .enforceElement(o, getRepresentationName());

        return new StringAttribute(XmlUtils.fetchTextContent(elt));
    }

}
