/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlWorkItemCoder.java 2500 2006-04-16 17:45:17Z jmettraux $
 */

//
// XmlWorkItemCoder.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.impl.workitem.xml;

import openwfe.org.Utils;
import openwfe.org.ApplicationContext;
import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.CancelItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.HistoryItem;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.participants.Filter;
import openwfe.org.engine.participants.FilterEntry;
import openwfe.org.engine.impl.workitem.AbstractWorkItemCoder;


/**
 * Sharing knowledge about xml {en|de}coding in the class
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-04-16 19:45:17 +0200 (Sun, 16 Apr 2006) $
 * <br>$Id: XmlWorkItemCoder.java 2500 2006-04-16 17:45:17Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class XmlWorkItemCoder

    extends AbstractWorkItemCoder

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlWorkItemCoder.class.getName());

    //
    // CONSTANTS & co

    public final static String WORKFLOW_DEFINITION_URL
        = "workflow-definition-url";
    public final static String PROCESS_DEFINITION_URL
        = "process-definition-url";

    public final static String WORKFLOW_DEFINITION_NAME
        = "workflow-definition-name";

    public final static String WORKFLOW_DEFINITION_REVISION
        = "workflow-definition-revision";

    public final static String WORKFLOW_INSTANCE_ID
        = "workflow-instance-id";

    public final static String LAST_MODIFIED
        = "last-modified";

    public final static String SIGNER
        = "signer";

    public final static String SIGNATURE
        = "signature";

    public final static String ATTRIBUTES
        = "attributes";

    public final static String PARTICIPANT_NAME
        = "participant-name";

    public final static String DISPATCH_TIME
        = "dispatch-time";

    public final static String LAST_EXPRESSION_ID
        = "last-expression-id";

    public final static String LAUNCHITEM
        = "launchitem";

    public final static String CANCELITEM
        = "cancelitem";

    public final static String WORKITEM
        = "workitem";

    public final static String DESCRIPTION_MAP
        = "description-map";

    public final static String FLOW_EXPRESSION_ID
        = "flow-expression-id";

    public final static String OWFE_VERSION
        = "owfe-version";

    public final static String ENGINE_ID
        = "engine-id";
    public final static String INITIAL_ENGINE_ID
        = "initial-engine-id";

    public final static String EXPRESSION_NAME
        = "expression-name";

    public final static String EXPRESSION_ID
        = "expression-id";

    public final static String OPEN_FILTER
        = "open-filter";

    public final static String CLOSED_FILTER
        = "closed-filter";

    public final static String REGEX
        = "regex";

    public final static String PERMISSIONS
        = "permissions";

    public final static String TYPE
        = "type";

    public final static String NAME
        = "name";

    public final static String ADD_ALLOWED
        = "add-allowed";

    public final static String REMOVE_ALLOWED
        = "remove-allowed";

    public final static String READ_WRITE
        = "read-write";

    public final static String READ_ONLY
        = "read-only";

    public final static String HIDE
        = "hide";

    public final static String FIELD
        = "field";

    public final static String HISTORY
        = "history";

    public final static String HISTORY_ITEM
        = "history-item";

    public final static String DATE
        = "date";

    public final static String AUTHOR
        = "author";

    public final static String HOST
        = "host";


    public final static int BUFFER_SIZE = 128 * 1024;

    /**
     * The short name (encoded name) for StringMapAttribute
     */
    public final static String SMAP = "smap";


    //
    // FIELDS

    private ApplicationContext applicationContext = null;
    private java.util.Map perRepresentationMap = null;

    //
    // CONSTRUCTORS

    public void init
        (final String name,
         final java.util.List attributeCoders,
         final ListenerReplyCoder replyCoder)
    {
        super.init(name, attributeCoders, replyCoder);

        this.perRepresentationMap = 
            new java.util.HashMap(attributeCoders.size());

        java.util.Iterator it = attributeCoders.iterator();
        while (it.hasNext())
        {
            AbstractXmlAttributeCoder coder = 
                (AbstractXmlAttributeCoder)it.next();

            this.perRepresentationMap.put
                (coder.getRepresentationName(), coder);

            log.debug
                ("init() put '"+coder.getClass().getName()+
                 "' for '"+coder.getRepresentationName()+"'");
        }
    }

    //
    // METHODS

    public AbstractXmlAttributeCoder getAttributeCoder 
        (final String representationName)
    {
        return (AbstractXmlAttributeCoder)perRepresentationMap
            .get(representationName);
    }

    //
    // ENCODING
    //

    /**
     * a shortcut method, it does :
     * <pre>
     * return (byte[])encode(wi, null, null);
     * </pre>
     */
    public byte[] doEncode (final WorkItem wi)
        throws CodingException
    {
        return (byte[])encode(wi, null, null);
    }

    /**
     * Encodes the workitem to a byte array (XML actually).
     */
    public Object encode 
        (final WorkItem wi, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        CodingException
    {
        log.debug("encode() wi of class "+wi.getClass().getName());

        this.applicationContext = context;

        org.jdom.Element eWi = encodeAsXml(wi);

        try
        {
            final Object o = XmlUtils.toByteArray(eWi);

            //openwfe.org.Utils.dump("xwic0_", (byte[])o);

            return o;
        }
        catch (openwfe.org.OpenWfeException owe)
        {
            throw new CodingException
                ("Failed to turn encoded workitem into a byte array", owe);
        }
    }

    protected org.jdom.Element encodeSuper (WorkItem wi)
        throws CodingException
    {
        org.jdom.Element elt = new org.jdom.Element(WORKITEM);

        /*
        WicUtils.setAttribute
            (elt, WORKFLOW_DEFINITION_URL, wi.getWorkflowDefinitionUrl());
        */

        if (wi.getLastModified() != null)
            WicUtils.setAttribute(elt, LAST_MODIFIED, wi.getLastModified());

        //elt.addContent(encodeFlowStack(wi.getFlowStack()));

        //
        // attributes
        
        org.jdom.Element as = new org.jdom.Element(ATTRIBUTES);
        org.jdom.Element smap = encodeAttribute(wi.getAttributes());
        if (smap != null) as.addContent(smap);
        elt.addContent(as);

        //
        // the end

        return elt;
    }

    public org.jdom.Element encodeAsXml (final WorkItem wi)
        throws CodingException
    {
        if (wi instanceof InFlowWorkItem)
            return encodeAsXml((InFlowWorkItem)wi);
        if (wi instanceof LaunchItem)
            return encodeAsXml((LaunchItem)wi);
        else
            return encodeCancelItemAsXml((CancelItem)wi);
    }

    protected org.jdom.Element encodeCancelItemAsXml (final CancelItem ci)
        throws CodingException
    {
        log.debug("encodeCancelItemAsXml() "+ci.getId());

        org.jdom.Element elt = encodeSuper(ci);
        elt.setName(CANCELITEM);

        //
        // expressionId

        org.jdom.Element ei = new org.jdom.Element(LAST_EXPRESSION_ID);
        ei.addContent(encode(ci.getId()));
        elt.addContent(ei);

        //
        // participant name

        WicUtils.setAttribute
            (elt, PARTICIPANT_NAME, ci.getParticipantName());

        //
        // done

        return elt;
    }

    protected org.jdom.Element encodeAsXml (final InFlowWorkItem wi)
        throws CodingException
    {
        org.jdom.Element elt = encodeSuper(wi);
        //elt.setName(WORKITEM);

        WicUtils.setAttribute
            (elt, PARTICIPANT_NAME, wi.getParticipantName());
        WicUtils.setAttribute
            (elt, DISPATCH_TIME, wi.getDispatchTime());

        //log.debug
        //    ("encodeAsXml(ifwi) wi.dispatchTime >"+wi.getDispatchTime()+"<");

        //
        // lastExpressionId

        if (wi.getLastExpressionId() != null)
        {
            org.jdom.Element lei = new org.jdom.Element(LAST_EXPRESSION_ID);
            lei.addContent(encode(wi.getLastExpressionId()));
            elt.addContent(lei);
        }

        //
        // filter

        if (wi.getFilter() != null)
        {
            elt.addContent(encode(wi.getFilter()));
        }

        //
        // history
        
        org.jdom.Element his = new org.jdom.Element(HISTORY);
        if (wi.getHistory() != null)
        {
            java.util.Iterator it = wi.getHistory().iterator();
            while (it.hasNext())
                his.addContent(encodeAsXml((HistoryItem)it.next()));
        }
        elt.addContent(his);

        return elt;
    }

    public org.jdom.Element encodeAsXml (HistoryItem hi)
    {
        org.jdom.Element elt = new org.jdom.Element(HISTORY_ITEM);

        elt.setAttribute
            (DATE, ""+hi.getDate());
        elt.setAttribute
            (AUTHOR, ""+hi.getAuthor());
        elt.setAttribute
            (HOST, ""+hi.getHost());
        elt.setAttribute
            (WORKFLOW_DEFINITION_NAME, ""+hi.getWorkflowDefinitionName());
        elt.setAttribute
            (WORKFLOW_DEFINITION_REVISION, ""+hi.getWorkflowDefinitionRevision());
        elt.setAttribute
            (WORKFLOW_INSTANCE_ID, ""+hi.getWorkflowInstanceId());
        elt.setAttribute
            (EXPRESSION_ID, ""+hi.getExpressionId());

        elt.setText(hi.getText());

        return elt;
    }

    protected org.jdom.Element encodeAsXml (final LaunchItem li)
        throws CodingException
    {
        org.jdom.Element elt = encodeSuper(li);
        elt.setName(LAUNCHITEM);

        //
        // wfdUrl

        //elt.setAttribute
        //    (WORKFLOW_DEFINITION_URL, li.getWorkflowDefinitionUrl());
        elt.setAttribute
            (PROCESS_DEFINITION_URL, li.getWorkflowDefinitionUrl());

        //
        // description map
        
        org.jdom.Element dm = new org.jdom.Element(DESCRIPTION_MAP);

        if (li.getDescriptionMap() != null)
            dm.addContent(encodeAttribute(li.getDescriptionMap()));

        elt.addContent(dm);

        return elt;
    }

    public org.jdom.Element encodeAttribute (final Attribute a)
        throws CodingException
    {
        if (a == null) return null;

        AttributeCoder coder = (AttributeCoder)getPerClassMap()
            .get(a.getClass().getName());

        if (coder == null)
        {
            org.jdom.Element elt = new org.jdom.Element("error");
            org.jdom.Comment cmt = new org.jdom.Comment
                ("No coder for Attribute of class '"+
                 a.getClass().getName()+"'");
            elt.addContent(cmt);
            return elt;
        }

        return (org.jdom.Element)coder.encode(a, null);
    }

    public org.jdom.Element encode (final FlowExpressionId fei)
    {
        final org.jdom.Element elt = new org.jdom.Element(FLOW_EXPRESSION_ID);

        WicUtils.setAttribute
            (elt, OWFE_VERSION, fei.getOwfeVersion());
        WicUtils.setAttribute
            (elt, ENGINE_ID, fei.getEngineId());
        WicUtils.setAttribute
            (elt, INITIAL_ENGINE_ID, fei.getInitialEngineId());
        WicUtils.setAttribute
            (elt, WORKFLOW_DEFINITION_URL, fei.getWorkflowDefinitionUrl());
        WicUtils.setAttribute
            (elt, WORKFLOW_DEFINITION_NAME, fei.getWorkflowDefinitionName());
        WicUtils.setAttribute
            (elt, WORKFLOW_DEFINITION_REVISION, fei.getWorkflowDefinitionRevision());
        WicUtils.setAttribute
            (elt, WORKFLOW_INSTANCE_ID, ""+fei.getWorkflowInstanceId());
        WicUtils.setAttribute
            (elt, EXPRESSION_NAME, fei.getExpressionName());
        WicUtils.setAttribute
            (elt, EXPRESSION_ID, ""+fei.getExpressionId());

        return elt;
    }

    /**
     * This method is public because it is used by 
     * openwfe.org.wfibuilder.WorkflowDefinition.outputAsXml()
     */
    public org.jdom.Element encode (Filter f)
    {
        org.jdom.Element elt = null;

        if (f.getType() == Filter.TYPE_OPEN)
            elt = new org.jdom.Element(OPEN_FILTER);
        else
            elt = new org.jdom.Element(CLOSED_FILTER);

        WicUtils.setAttribute(elt, NAME, f.getName());
        WicUtils.setAttribute(elt, ADD_ALLOWED, ""+f.isAddAllowed());
        WicUtils.setAttribute(elt, REMOVE_ALLOWED, ""+f.isRemoveAllowed());
        
        encodeEntryList(elt, f);

        return elt;
    }

    protected void encodeEntryList (org.jdom.Element result, Filter f)
    {
        if (f.getEntries() == null || f.getEntries().size() < 1)
        {
            //log.debug("encodePatternList() - list is empty");
            return;
        }

        java.util.Iterator it = f.getEntries().iterator();
        while (it.hasNext())
        {
            FilterEntry entry = (FilterEntry)it.next();

            if (entry.getPermissions().trim().equals("")) continue;
                // do not add 'hidden' fields

            org.jdom.Element elt = new org.jdom.Element(FIELD);

            elt.setAttribute(REGEX, entry.getFieldRegex());
            elt.setAttribute(PERMISSIONS, entry.getPermissions());

            //if (entry.getAttributeType() != null)
            //    elt.setAttribute(TYPE, entry.getAttributeType());

            result.addContent(elt);
        }
    }

    //
    // DECODING
    //

    protected org.jdom.Document fetchDocument (final Object o)
        throws CodingException
    {

        log.debug("fetchDocument() instance of "+o.getClass().getName());

        //
        // turn anything into an input stream

        java.io.InputStream stream = null;
        java.io.Reader reader = null;

        try
        {
            if (o instanceof java.io.Reader)
            {
                reader = (java.io.Reader)o;
            }
            else if (o instanceof java.io.File)
            {
                reader = new java.io.FileReader((java.io.File)o);
            }
            else if (o instanceof String)
            {
                reader = new java.io.StringReader((String)o);
            }
            else if (o instanceof java.io.InputStream)
            {
                //reader = prefetch((java.io.InputStream)o);

                //reader = new java.io.InputStreamReader
                //    ((java.io.InputStream)o, Utils.getCharset());

                stream = (java.io.InputStream)o;
            }
            else if (o instanceof java.net.URL)
            {
                //reader = new java.io.InputStreamReader
                //    (((java.net.URL)o).openStream());

                stream = ((java.net.URL)o).openStream();
            }
            else if (o instanceof org.jdom.Document)
            {
                return (org.jdom.Document)o;
            }
            else if (o instanceof org.jdom.Element)
            {
                return (org.jdom.Document)((org.jdom.Element)o).getParent();
            }
            /*
            else if (o instanceof java.nio.channels.ReadableByteChannel)
            {
                reader = NetUtils.channelToReader
                    ((java.nio.channels.ReadableByteChannel)o);
            }
            */
            else
            {
                throw new CodingException
                    ("Cannot decode "+o.getClass().getName());
            }
        }
        catch (final Throwable t)
        {
            throw new CodingException
                ("Failed to decode workitem", t);
        }

        if (stream != null)
            log.debug("fetchDocument() using stream.");
        else
            log.debug("fetchDocument() using reader.");

        //
        // generate xml doc
        
        final org.jdom.input.SAXBuilder builder = 
            new org.jdom.input.SAXBuilder();

        org.jdom.Document doc = null;
        try
        {
            if (stream != null) 
                doc = builder.build(stream);
            else
                doc = builder.build(reader);
        }
        catch (final Throwable t)
        {
            throw new CodingException
                ("Failed to decode incoming workitem with SAX", t);
        }
        finally
        {
            try
            {
                if (stream != null) stream.close();
                if (reader != null) reader.close();
            }
            catch (final Throwable t)
            {
                // ignore
            }
        }

        //log.debug("fetchDocument() document built");

        return doc;
    }

    public WorkItem decode 
        (final Object o,
         final ApplicationContext context,
         final java.util.Map serviceParams) 
    throws 
        CodingException
    {

        log.debug("decode()");

        org.jdom.Document doc = fetchDocument(o);

        org.jdom.Element rootElt = doc.getRootElement();

        //
        // determine type of workitem
        
        WorkItem wi = null;

        log.debug("decode() rootElt is >"+rootElt.getName()+"<");
        
        if (rootElt.getName().equals(WORKITEM))
        {
            wi = decodeInFlowWorkItem(rootElt);
        }
        else if (rootElt.getName().equals(LAUNCHITEM))
        {
            wi = decodeLaunchItem(rootElt);
        }
        else if (rootElt.getName().equals(CANCELITEM))
        {
            wi = decodeCancelItem(rootElt);
        }
        else
        {
            throw new CodingException
                ("Cannot handle elements named '"+
                 rootElt.getName()+"' as workitems");
        }

        decodeWorkItem(wi, rootElt);

        //
        // return result
        
        return wi;
    }

    /**
     * Decoding a FlowExpressionId out of XML.
     */
    public FlowExpressionId decodeFlowExpressionId (final org.jdom.Element elt)
    {
        FlowExpressionId fei = new FlowExpressionId();

        fei.setOwfeVersion
            (elt.getAttributeValue(OWFE_VERSION));
        fei.setEngineId
            (elt.getAttributeValue(ENGINE_ID));
        fei.setInitialEngineId
            (elt.getAttributeValue(INITIAL_ENGINE_ID));
        fei.setWorkflowDefinitionUrl
            (elt.getAttributeValue(WORKFLOW_DEFINITION_URL));
        fei.setWorkflowDefinitionName
            (elt.getAttributeValue(WORKFLOW_DEFINITION_NAME));
        fei.setWorkflowDefinitionRevision
            (elt.getAttributeValue(WORKFLOW_DEFINITION_REVISION));
        fei.setExpressionName
            (elt.getAttributeValue(EXPRESSION_NAME));

        fei.setWorkflowInstanceId
            (elt.getAttributeValue(WORKFLOW_INSTANCE_ID));
        fei.setExpressionId
            (elt.getAttributeValue(EXPRESSION_ID));

        return fei;
    }

    protected void decodeWorkItem 
        (final WorkItem target, final org.jdom.Element elt)
    throws 
        CodingException
    {
        
        log.debug("decodeworkItem()");

        target.setLastModified
            (elt.getAttributeValue(LAST_MODIFIED));

        //log.debug("decodeWorkItem() got 'lastModified'");

        //
        // parse attributes
        
        org.jdom.Element attElt = elt.getChild(ATTRIBUTES);
        if (attElt != null)
        {
            attElt = attElt.getChild(SMAP);

            if (attElt != null)
            {
                AttributeCoder coder = getAttributeCoder(SMAP);

                target.setAttributes((StringMapAttribute)coder
                    .decode(attElt, null));
            }
        }
    }

    /**
     * Directly decodes an attribute out of an XML fragment.
     */
    public Attribute decodeAttribute (final org.jdom.Element elt)
        throws CodingException
    {
        AttributeCoder coder = getAttributeCoder(elt.getName());

        if (coder == null)
            throw new CodingException("No coder for '"+elt.getName()+"'");

        return coder.decode(elt, null);
    }

    protected InFlowWorkItem decodeInFlowWorkItem (final org.jdom.Element elt)
        throws CodingException
    {
        InFlowWorkItem wi = new InFlowWorkItem();

        org.jdom.Element leiElt = elt.getChild(LAST_EXPRESSION_ID);
        if (leiElt != null)
        {
            leiElt = leiElt.getChild(FLOW_EXPRESSION_ID);
            wi.setId(decodeFlowExpressionId(leiElt));
        }

        wi.setParticipantName(elt.getAttributeValue(PARTICIPANT_NAME));
        wi.setDispatchTime(elt.getAttributeValue(DISPATCH_TIME));

        //log.debug
        //    ("decodeInFlowWorkItem() wi.dispatchTime >"+
        //     wi.getDispatchTime()+"<");

        //
        // decode filter

        wi.setFilter(decodeFilter(elt));

        //
        // decode history
        
        wi.setHistory(decodeHistory(elt));


        return wi;
    }

    protected CancelItem decodeCancelItem (final org.jdom.Element elt)
        throws CodingException
    {
        CancelItem ci = new CancelItem();

        org.jdom.Element eiElt = elt.getChild(LAST_EXPRESSION_ID);
        if (eiElt != null)
        {
            eiElt = eiElt.getChild(FLOW_EXPRESSION_ID);
            ci.setId(decodeFlowExpressionId(eiElt));
        }

        ci.setParticipantName(elt.getAttributeValue(PARTICIPANT_NAME));

        return ci;
    }

    protected java.util.List decodeHistory (final org.jdom.Element elt)
    {
        java.util.List history = new java.util.ArrayList(7);

        org.jdom.Element hElt = elt.getChild(HISTORY);
        if (hElt == null) return history;

        java.util.Iterator it = hElt.getChildren(HISTORY_ITEM).iterator();
        while (it.hasNext())
            history.add(decodeHistoryItem((org.jdom.Element)it.next()));

        return history;
    }

    protected HistoryItem decodeHistoryItem (org.jdom.Element elt)
    {
        HistoryItem item = new HistoryItem();

        item.setDate(elt.getAttributeValue(DATE));
        item.setAuthor(elt.getAttributeValue(AUTHOR));
        item.setHost(elt.getAttributeValue(HOST));
        item.setText(elt.getTextTrim());

        item.setWorkflowDefinitionName
            (elt.getAttributeValue(WORKFLOW_DEFINITION_NAME));
        item.setWorkflowDefinitionRevision
            (elt.getAttributeValue(WORKFLOW_DEFINITION_REVISION));
        try
        {
            item.setWorkflowInstanceId
                (elt.getAttributeValue(WORKFLOW_INSTANCE_ID));
        }
        catch (NumberFormatException nfe)
        {
            // let workflow instance id to -1
        }

        item.setExpressionId(elt.getAttributeValue(EXPRESSION_ID));

        return item;
    }

    protected Filter decodeFilter (org.jdom.Element elt)
    {
        org.jdom.Element filterElt = elt.getChild(CLOSED_FILTER);
        if (filterElt == null) filterElt = elt.getChild(OPEN_FILTER);

        if (filterElt == null) return null; // no filter at all

        Filter filter = new Filter();

        if (filterElt.getName().equals(OPEN_FILTER))
            filter.setType(Filter.TYPE_OPEN);
        else
            filter.setType(Filter.TYPE_CLOSED);

        filter.setName(filterElt.getAttributeValue(NAME));
        //log.debug("*********** FilterName >"+filter.getName()+"<");

        String s = filterElt.getAttributeValue(ADD_ALLOWED);
        //log.debug("*********** AddAllowed ? >"+s+"<");
        filter.setAddAllowed
            (s != null && s.trim().toLowerCase().equals("true"));

        s = filterElt.getAttributeValue(REMOVE_ALLOWED);
        //log.debug("*********** RemoveAllowed ? >"+s+"<");
        filter.setRemoveAllowed
            (s != null && s.trim().toLowerCase().equals("true"));

        filter.setEntries(decodeEntryList(filterElt));

        return filter;
    }

    protected java.util.List decodeEntryList (org.jdom.Element filterElt)
    {
        java.util.List result = new java.util.ArrayList();

        java.util.Iterator it = filterElt.getChildren(FIELD).iterator();
        while (it.hasNext())
        {
            org.jdom.Element elt = (org.jdom.Element)it.next();

            String fieldRegex = elt.getAttributeValue(REGEX).trim();
            String permissions = elt.getAttributeValue(PERMISSIONS).trim();

            //String type = elt.getAttributeValue(TYPE);

            FilterEntry entry = 
                new FilterEntry(fieldRegex, permissions/*, type*/);

            result.add(entry);
        }
        
        return result;
    }

    protected LaunchItem decodeLaunchItem (org.jdom.Element elt)
        throws CodingException
    {
        LaunchItem li = new LaunchItem();

        //
        // decode wfdUrl

        li.setWorkflowDefinitionUrl
            (elt.getAttributeValue(WORKFLOW_DEFINITION_URL)); 

        if (li.getWorkflowDefinitionUrl() == null)
        {
            li.setWorkflowDefinitionUrl
                (elt.getAttributeValue(PROCESS_DEFINITION_URL)); 
        }

        //log.debug
        //    ("decodeLaunchItem() wfdUrl is >"+
        //     li.getWorkflowDefinitionUrl()+"<");

        //
        // decode description map
        
        org.jdom.Element dmElt = elt.getChild(DESCRIPTION_MAP);

        if (dmElt != null && dmElt.getChild(SMAP) != null)
        {
            //log.debug("parsing launchitem description map");

            dmElt = dmElt.getChild(SMAP);

            AttributeCoder coder = getAttributeCoder(SMAP);

            StringMapAttribute smap = (StringMapAttribute)coder
                .decode(dmElt, null);

            li.setDescriptionMap(smap);
        }

        return li;
    }

    //
    // STATIC METHODS

}
