/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: EngineWorkItemConsumer.java 2414 2006-03-10 22:15:03Z jmettraux $
 */

//
// EngineWorkItemConsumer.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.listen;

import openwfe.org.OpenWfeException;
import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.history.History;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * This consumer simply takes care of routing incoming workitems to the
 * appropriate engine service.
 * Incoming workitems arrive through the listeners configured for the engine.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-03-10 23:15:03 +0100 (Fri, 10 Mar 2006) $
 * <br>$Id: EngineWorkItemConsumer.java 2414 2006-03-10 22:15:03Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class EngineWorkItemConsumer

    extends AbstractWorkItemConsumer

{

    private final static org.apache.log4j.Logger cat = org.apache.log4j.Logger
        .getLogger(EngineWorkItemConsumer.class.getName());

    //
    // FIELDS

    //
    // CONSTRUCTORS

    //
    // METHODS

    /**
     * This method looks at the wi and either reply to the corresponding
     * ParticipantExpression either launch a new wf.
     */
    public Object use (final WorkItem wi)
        throws OpenWfeException
    {
        if (wi instanceof LaunchItem)
        {
            return launch((LaunchItem)wi);
        }

        if (wi instanceof WorkItem)
        {
            reply((InFlowWorkItem)wi);
            return null;
        }

        throw new OpenWfeException
            ("The engine cannot use a WorkItem of class "+
             wi.getClass().getName());
    }

    /**
     * Takes care of handling the workitem (reply) to the expression pool.
     */
    protected void reply (final InFlowWorkItem wi)
        throws ReplyException
    {
        final History h = Definitions.getHistory(getContext());

        if (h != null)
        {
            h.log
                (wi.getLastExpressionId(),
                 wi,
                 History.EVT_INCOMING,
                 wi.getParticipantName(),
                 ""); 
        }

        Definitions.getExpressionPool(getContext())
            .reply(wi.getLastExpressionId(), wi);
    }

    /**
     * Takes care of launching the new flow as requested (by the mean
     * of a launchitem).
     */
    protected FlowExpressionId launch (final LaunchItem li)
        throws OpenWfeException
    {
        //final WorkflowInstanceBuilder builder = 
        //    Definitions.getWorkflowInstanceBuilder(getContext());
        
        final Launcher launcher = Definitions.getLauncher(getContext());

        return launcher.launch(li, true);
    }

    //
    // METHODS from Service

    /**
     * Not much info to return...
     */
    public org.jdom.Element getStatus ()
    {
        final org.jdom.Element result = new org.jdom.Element(getName());

        result.addContent(XmlUtils.getClassElt(this));
        result.addContent(XmlUtils.getRevisionElt("$Id: EngineWorkItemConsumer.java 2414 2006-03-10 22:15:03Z jmettraux $"));

        return result;
    }

}
