/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractParticipantMap.java 2495 2006-04-16 13:44:21Z jmettraux $
 */

//
// AbstractParticipantMap.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.participants;

import openwfe.org.AbstractService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;


/**
 * A list of participants. 
 * The list is not cached, it is reloaded upon each request.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-04-16 15:44:21 +0200 (Sun, 16 Apr 2006) $
 * <br>$Id: AbstractParticipantMap.java 2495 2006-04-16 13:44:21Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public abstract class AbstractParticipantMap

    extends AbstractService

    implements ParticipantMap

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AbstractParticipantMap.class.getName());

    //
    // FIELDS

    private java.util.List participants = null;

    //
    // CONSTRUCTORS

    public AbstractParticipantMap ()
    {
        super();

        this.participants = new java.util.ArrayList(35);
    }

    //
    // BEAN METHODS

    public java.util.List getParticipants ()
    {
        return this.participants;
    }

    public void setParticipants (final java.util.List l)
    {
        this.participants = l;
    }

    //
    // METHODS

    /**
     * Adds a participant to this map.
     */
    public void add (final Participant p)
    {
        if (this.participants == null) 
            this.participants = new java.util.ArrayList(20);

        synchronized (this.participants)
        {
            if (p != null) this.participants.add(p);
        }
    }

    /**
     * Returns the Participant instance behind a given participant name
     * (The core job of this class)
     */
    public Participant get (final String participantName)
    {
        log.debug("get() looking for participant >"+participantName+"<");

        synchronized (this.participants)
        {
            try
            {
                refreshMap();
            }
            catch (ServiceException se)
            {
                log.warn
                    ("Failed to refresh participant map", se);
            }

            //log.debug
            //    ("get() available participants : "+this.participants.size());

            if (participantName == null) return null;

            for (int i=0; i < this.participants.size(); i++)
            {
                final Participant p = (Participant)this.participants.get(i);

                //log.debug
                //    ("get() considering participant >"+p.getRegex()+"<");

                if (p.getRegex() != null &&
                    participantName.matches(p.getRegex()))
                {
                    return p;
                }
            }

            return null;
        }
    }

    //
    // ABSTRACT METHODS

    /**
     * Implement this method in order to allow the participant map to 
     * refresh its content if the source document/db/whatever of it
     * has changed.
     */
    protected abstract void refreshMap ()
        throws ServiceException;

}
