/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: LeafParticipant.java 2494 2006-04-15 21:15:08Z jmettraux $
 */

//
// LeafParticipant.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.participants;

import openwfe.org.Service;
import openwfe.org.MapUtils;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.history.History;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.InFlowItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.dispatch.WorkItemDispatcher;
import openwfe.org.engine.dispatch.DispatchingException;


/**
 * A participant to a workflow.
 * Its name, its dispatcher class and a few parameters
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-04-15 23:15:08 +0200 (Sat, 15 Apr 2006) $
 * <br>$Id: LeafParticipant.java 2494 2006-04-15 21:15:08Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class LeafParticipant

    extends AbstractParticipant

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(LeafParticipant.class.getName());

    //
    // CONSTANTS & co

    /**
     * The 'dispatcherClass' parameter is used to indicate to this leaf
     * participant which java class it should use for doing the real
     * dispatch work.
     */
    public final static String P_DISPATCHER_CLASS
        = "dispatcherClass";

    //
    // FIELDS

    private String dispatcherClassName = null;

    //
    // CONSTRUCTORS

    public void init
        (//final ParticipantMap pMap,
         final String regex,
         final java.util.Map params)
    {
        //super.init(pMap, regex, params);
        super.init(regex, params);

        this.dispatcherClassName = MapUtils
            .getAsString(params, P_DISPATCHER_CLASS);
    }

    //
    // BEAN METHODS

    public String getDispatcherClassName () 
    { 
        return this.dispatcherClassName; 
    }

    public void setDispatcherClassName (final String s) 
    { 
        this.dispatcherClassName = s; 
    }

    //
    // METHODS

    protected WorkItemDispatcher instantiateDispatcher 
        (final ApplicationContext context, final WorkItem wi)
    throws 
        DispatchingException
    {
        WorkItemDispatcher dispatcher = null;

        if (this.dispatcherClassName == null)
        {
            throw new DispatchingException
                ("participant '"+this.getRegex()+"' is missing a "+
                 "'dispatcherClass' parameter, "+
                 "cannot dispatch workitems to it");
        }

        try
        {
            Class dispatcherClass = Class.forName(this.dispatcherClassName);

            dispatcher = (WorkItemDispatcher)dispatcherClass.newInstance();

            java.util.Map dispatcherParams = new java.util.HashMap();
            dispatcherParams.putAll(getParams());

            dispatcherParams.put(PARTICIPANT_NAME, this.getRegex());

            //
            // init dispatcher

            dispatcher.init
                (getRegex()+".dispatcher", 
                 //((Service)getParticipantMap()).getContext(), 
                 context,
                 dispatcherParams);
        }
        catch (Exception e)
        {
            throw new DispatchingException
                ("Failed to instantiate dispatcher '"+this.dispatcherClassName+
                 "' for participant '"+getRegex()+"'", e);
        }

        return dispatcher;
    }

    public Object dispatch 
        (final ApplicationContext context, final WorkItem wi)
    throws 
        DispatchingException
    {
        final WorkItemDispatcher dispatcher = 
            instantiateDispatcher(context, wi);

        //
        // set information that might be relevant
        // for a worklist or any other kind of workitem recipient

        if (wi instanceof InFlowItem)
        {
            final InFlowItem ifi = (InFlowItem)wi;

            if (ifi.getParticipantName() == null) 
                ifi.setParticipantName(getRegex());

            log.debug
                ("dispatch() set participant name to >"+getRegex()+
                 "< as it was missing.");
        }

        wi.touch();

        //
        // history
        
        final History history = Definitions.getHistory
            //(((Service)getParticipantMap()).getContext());
            //(getParticipantMap().getContext());
            (context);
        
        if (wi instanceof InFlowWorkItem && history != null)
        {
            final InFlowWorkItem ifwi = (InFlowWorkItem)wi;

            history.log
                (ifwi.getLastExpressionId(),
                 ifwi,
                 History.EVT_DISPATCH,
                 ifwi.getParticipantName(),
                 this.getClass().getName());
        }

        //
        // dispatch

        return dispatcher.dispatch(wi);
    }

}
