/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Participant.java 2494 2006-04-15 21:15:08Z jmettraux $
 */

//
// Participant.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 20.11.2001 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.participants;

import openwfe.org.ApplicationContext;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.dispatch.DispatchingException;


/**
 * The basic interface for a participant : you can dispatch a work item 
 * to it
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-04-15 23:15:08 +0200 (Sat, 15 Apr 2006) $
 * <br>$Id: Participant.java 2494 2006-04-15 21:15:08Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface Participant
{

    //
    // CONSTANTS (definitions)

    /**
     * this key is used to pass the name of the leaf participant to the
     * dispatcher
     */
    public final static String PARTICIPANT_NAME
        = "__participant__";

    //
    // METHODS

    /**
     * Returns the name (usually a regex) of this participant.
     */
    public String getRegex ();

    /**
     * Sets the regex (or simply the name) of this participant.
     */
    public void setRegex (final String s);

    /**
     * Participant shall have a constructor with no arguments and use
     * this method to finish their instantiation.
     */
    public void init 
        (//ParticipantMap pMap,
         String regex,
         java.util.Map params);

    /**
     * Returns the params that presided the construction of the participant.
     * This may be useful for determining, for example, a timeout set
     * at participant level...
     */
    public java.util.Map getParams ();

    /**
     * implement this method to explain how workitems should be passed
     * to the participant
     *
     * @param context The application context of the engine (or any other
     * OpenWFE component) using this participant.
     * @param wi The workitem to handle to the participant.
     *
     * @return some dispatching result
     */
    public Object dispatch 
        (ApplicationContext context, WorkItem wi) 
    throws 
        DispatchingException;

}
