/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Base64Attribute.java 1882 2005-05-17 16:41:07Z jmettraux $
 */

//
// Base64Attribute.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

import openwfe.org.Utils;
import openwfe.org.misc.Base64;


/**
 * Encapsulating binary data in an attribute.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-05-17 18:41:07 +0200 (Tue, 17 May 2005) $
 * <br>$Id: Base64Attribute.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class Base64Attribute

    extends AtomicAttribute

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(Base64Attribute.class.getName());

    //
    // FIELDS

    //
    // CONSTRUCTORS

    /**
     * Builds an empty Base64Attribute.
     */
    public Base64Attribute ()
    {
        super(null);
    }

    /**
     * The object awaited is base64 string (representing the binary data to
     * wrap), the better way to manually create a Base64Attribute is to 
     * use newBase64Attribute().
     */
    public Base64Attribute (final Object o)
    {
        super(o);
    }

    //
    // METHODS

    /**
     * Returns the payload as the array of bytes it represents
     * (the payload is stored as a base64 encoded string).
     */
    public byte[] getBytes ()
    {
        if (getValue() == null) return null;

        final String s = (String)getValue();

        try
        {
            return Base64.decode(s.getBytes("ascii"));
        }
        catch (final java.io.UnsupportedEncodingException e)
        {
            log.warn("getBytes() failure", e);
            return null;
        }
    }

    /**
     * Builds a new Base64Attribute from the binary data given as
     * argument (the payload will be a base64 string).
     */
    public static Base64Attribute newBase64Attribute (final byte[] bytes)
    {
        final byte[] b64s = Base64.encode(bytes);

        String s = null;
        try
        {
            s = new String(b64s, "ascii");
        }
        catch (final java.io.UnsupportedEncodingException e)
        {
            log.warn("fromBytes() failure", e);
            return null;
        }

        return new Base64Attribute(s);
    }

    /*
    private static String dumpBytes (byte[] bytes)
    {
        final String fileName = 
            Utils.getTempDir()+"/dump"+System.currentTimeMillis()+".png";

        try
        {
            final java.io.FileOutputStream fos = 
                new java.io.FileOutputStream(fileName);
            fos.write(bytes);
            fos.flush();
            fos.close();
        }
        catch (final Throwable t)
        {
            log.warn("dumpBytes() failure", t);
        }

        return fileName;
    }
    */

    /**
     * Returns a copy of this Base64Attribute.
     */
    public Object clone ()
    {
        if (getValue() == null) 
            return new Base64Attribute();

        return new Base64Attribute(new String((String)this.getValue()));
    }

}
