/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: InFlowItem.java 2047 2005-08-17 12:08:22Z jmettraux $
 */

//
// InFlowItem.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

import openwfe.org.engine.expressions.InFlowObject;
import openwfe.org.engine.expressions.FlowExpressionId;


/**
 * The base implementation for InFlowWorkItem and CancelItem.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: InFlowItem.java 2047 2005-08-17 12:08:22Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public abstract class InFlowItem

    extends WorkItem

    implements InFlowObject

{

    static final long serialVersionUID = -4778197703733009725L;

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(InFlowItem.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    private String participantName = null;
    private FlowExpressionId id = null;

    //
    // CONSTRUCTORS

    /**
     * Builds an empty (and incomplete) InFlowItem.
     */
    public InFlowItem ()
    {
        super();
    }

    /**
     * Builds a an InFlowItem for a given expression and a given participant.
     */
    public InFlowItem (final FlowExpressionId id, final String participantName)
    {
        super();

        this.id = id;
        this.participantName = participantName;
    }

    //
    // BEAN METHODS

    /**
     * The method from InFlowObject.
     */
    public FlowExpressionId getId ()
    {
        return this.id;
    }

    /**
     * When the workitem (cancelitem) is sent to a participant, this
     * field is set to the name of the participant as determined from
     * the process definition (ref, field-ref,...)
     */
    public String getParticipantName () 
    { 
        return this.participantName; 
    }

    public void setId (final FlowExpressionId fei)
    {
        this.id = fei;
    }

    public void setParticipantName (final String s) 
    { 
        this.participantName = s; 
    }

    //
    // METHODS

}
