/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: LongAttribute.java 1882 2005-05-17 16:41:07Z jmettraux $
 */

//
// LongAttribute.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

/**
 * A long
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-05-17 18:41:07 +0200 (Tue, 17 May 2005) $
 * <br>$Id: LongAttribute.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class LongAttribute

    extends AtomicAttribute

{

    //
    // FIELDS

    //
    // CONSTRUCTORS

    public LongAttribute ()
    {
        this(0L);
    }

    public LongAttribute (long l)
    {
        super(new Long(l));
    }

    public LongAttribute (Long l)
    {
        super(l);
    }

    public LongAttribute (String s)
    {
        this(0L);
        try
        {
            this.value = new Long(s);
        }
        catch (NumberFormatException nfe)
        {
            // ignore
        }
    }

    //
    // METHODS

    public long longValue ()
    {
        return ((Long)this.value).longValue();
    }

    public Object clone ()
    {
        return new LongAttribute(longValue());
    }

}
