/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: StringAttribute.java 2098 2005-09-06 17:05:37Z jmettraux $
 */

//
// StringAttribute.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

import openwfe.org.Utils;


/**
 * A StringAttribute is either the name of a workitem field or its value.
 * It's an encapsulation of a Java String.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-09-06 19:05:37 +0200 (Tue, 06 Sep 2005) $
 * <br>$Id: StringAttribute.java 2098 2005-09-06 17:05:37Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class StringAttribute

    extends AtomicAttribute

{

    //
    // FIELDS

    //
    // CONSTRUCTORS

    /**
     * Builds an empty StringAttribute, value set to "".
     */
    public StringAttribute ()
    {
        super("");
    }

    /**
     * Turns the object into a String and then builds a StringAttribute
     * instance wrapping this String instance.
     */
    public StringAttribute (final Object o)
    {
        super(""+o);
    }

    //
    // METHODS

    /**
     * Simply returns the wrapped String.
     */
    public String toString ()
    {
        return (String)this.value;
    }

    /**
     * Returns a copy of this StringAttribute.
     */
    public Object clone ()
    {
        try
        {
            return new StringAttribute
                (new String
                     (toString().getBytes(Utils.getEncoding()), 
                      Utils.getEncoding()));
        }
        catch (final java.io.UnsupportedEncodingException e)
        {
            throw new IllegalArgumentException
                ("clone() failure "+e);
        }
    }

}
