/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: XmlCoderLoader.java 2414 2006-03-10 22:15:03Z jmettraux $
 */

//
// XmlCoderLoader.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.engine.workitem;

import openwfe.org.Utils;
import openwfe.org.AbstractService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.Parameters;
import openwfe.org.xml.XmlUtils;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;


/**
 * The default WorkItemCoderLoader implementation.
 * Fetches its configuration from the parameter 'configurationFile'.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-03-10 23:15:03 +0100 (Fri, 10 Mar 2006) $
 * <br>$Id: XmlCoderLoader.java 2414 2006-03-10 22:15:03Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class XmlCoderLoader

    extends AbstractService

    implements WorkItemCoderLoader

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(XmlCoderLoader.class.getName());

    //
    // CONSTANTS

    protected final static String DEFAULT
        = "__default__";

    protected final static String XML
        = "__xml__";

    //
    // FIELDS

    private java.util.Map map = null;

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        Object oConf = serviceParams.get(CONFIGURATION_FILE);

        if (oConf == null)
        {
            throw new ServiceException
                ("parameter "+CONFIGURATION_FILE+
                 "' is mandatory for service "+getName()+
                 " ("+this.getClass().getName()+")");
        }

        log.debug("init() oConf is instance of "+oConf.getClass().getName());

        java.util.List confFileNames = null;
        if (oConf instanceof java.util.List)
        {
            java.util.Iterator it = ((java.util.List)oConf).iterator();

            while (it.hasNext()) 
                loadConfigurationFile((String)it.next());
        }
        else
        {
            loadConfigurationFile((String)oConf);
        }
    }

    //
    // METHODS from WorkItemCoderLoader

    /**
     * Returns an instance of the default coder.
     */
    public WorkItemCoder getDefaultCoder ()
    {
        return (WorkItemCoder)this.map.get(DEFAULT);
    }

    /**
     * Returns an instance of the XML coder 
     * (the one used for the REST interface precisely).
     */
    public WorkItemCoder getXmlCoder ()
    {
        return (WorkItemCoder)this.map.get(XML);
    }

    /**
     * Given a name, returns an instance of the corresponding coder.
     */
    public WorkItemCoder getCoder (String name)
    {
        return (WorkItemCoder)this.map.get(name);
    }

    //
    // METHODS

    protected void loadConfigurationFile (final String fileName)
        throws ServiceException
    {
        if (this.map == null) this.map = new java.util.HashMap();

        try
        {
            log.info("loadConfigurationFile() raw  "+fileName);

            final String fn = Utils.expandUrl(fileName);

            log.info("loadConfigurationFile()      "+fn);

            final org.jdom.Element root = 
                XmlUtils.extractXml(fn, false);

            java.util.Iterator it = 
                root.getChildren("workitem-coder").iterator();
            while (it.hasNext())
            {
                buildCoderConfiguration((org.jdom.Element)it.next());
            }
        }
        catch (ServiceException se)
        {
            throw se;
        }
        catch (Exception e)
        {
            throw new ServiceException
                ("Failed to build AttributeCoder list "+
                 "from file '"+fileName+"'", e);
        }
    }

    protected void buildCoderConfiguration 
        (final org.jdom.Element conf)
    throws 
        ServiceException
    {
        String name = conf.getAttributeValue("name");
        String className = conf.getAttributeValue("class");
        String sDefault = conf.getAttributeValue("default");

        if (name == null || className == null)
        {
            throw new ServiceException
                ("Attribute 'name' or 'class' is missing from WorkItemCoder "+
                 "configuration file");
        }

        log.info("building coder '"+name+"'");

        //
        // instantiate coder class
        
        WorkItemCoder workItemCoder = null;
        try
        {
            Class coderClass = Class.forName(className);
            workItemCoder = (WorkItemCoder)coderClass.newInstance();
        }
        catch (Exception e)
        {
            throw new ServiceException
                ("Failed to instantiate coder '"+name+
                 "' with class '"+className+"'", e);
        }

        log.debug("buildCoderConfiguration() workItemCoder instantiated");

        //
        // set attributes map
        
        java.util.List attributeList = new java.util.ArrayList();
        
        java.util.Iterator it = conf.getChildren("attribute-coder").iterator();
        while (it.hasNext())
        {
            AttributeCoder attributeCoder = 
                buildAttributeCoder(workItemCoder, (org.jdom.Element)it.next());

            attributeList.add(attributeCoder);
        }

        log.debug("buildCoderConfiguration() attributeList filled");

        //
        // set reply coder
        
        org.jdom.Element elt = conf.getChild("reply-coder");
        if (elt == null)
        {
            throw new ServiceException
                ("Element 'replyCoder' is mandatory in coder configuration. "+
                 "It is missing for coder '"+name+"'");
        }

        String replyCoderClassName = elt.getAttributeValue("class");

        ListenerReplyCoder replyCoder = null;
        try
        {
            Class replyCoderClass = Class.forName(replyCoderClassName);
            replyCoder = (ListenerReplyCoder)replyCoderClass.newInstance();
        }
        catch (Exception e)
        {
            throw new ServiceException
                ("Failed to instantiate coder '"+name+
                 "' listenerReplyCoder with class '"+
                 replyCoderClassName+"'", e);
        }

        log.debug("buildCoderConfiguration() replyCoder instantiated");

        //
        // init coder
        
        workItemCoder.init(name, attributeList, replyCoder);

        log.debug("buildCoderConfiguration() workItemCoder initialized");

        //
        // store in coder map
        
        this.map.put(name, workItemCoder);

        log.info("Built workItemCoder '"+name+"'");

        if (sDefault != null && sDefault.trim().toLowerCase().equals("true"))
        {
            log.info("Setting workItemCoder '"+name+"' as default");
            this.map.put(DEFAULT, workItemCoder);
        }

        if (workItemCoder instanceof 
                openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder)
        {
            log.info("Setting workItemCoder '"+name+"' as xmlCoder");
            this.map.put(XML, workItemCoder);
        }
    }

    protected AttributeCoder buildAttributeCoder 
        (WorkItemCoder workItemCoder, org.jdom.Element conf)
    throws 
        ServiceException
    {
        String coderClassName = conf.getAttributeValue("class");

        if (coderClassName == null)
        {
            throw new ServiceException
                ("Attribute 'coderClass' "+
                 "is missing from AttributeCoder configuration");
        }

        log.debug("buildAttributeCoder() coderClassName is "+coderClassName);

        AttributeCoder coder = null;
        try
        {
            Class coderClass = Class.forName(coderClassName);
            coder = (AttributeCoder)coderClass.newInstance();

            java.util.Map params = Parameters.extractAttributes(conf);

            coder.init(workItemCoder, params);
        }
        catch (Exception e)
        {
            throw new ServiceException
                ("Failed to instantiate AttributeCoder for class '"+
                 coderClassName+"'", e);
        }

        return coder;
    }

}
