/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ReflectionUtils;
import openwfe.org.Utils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.VariableMap;
import openwfe.org.engine.expressions.map.ExpressionMap;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.expressions.state.ExpressionState;
import openwfe.org.engine.history.History;
import openwfe.org.engine.launch.Launcher;
import openwfe.org.engine.participants.ParticipantMap;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.misc.Text;
import openwfe.org.time.Time;
import openwfe.org.xml.XmlCoder;
import org.apache.log4j.Logger;
import org.jdom.Element;

public abstract class AbstractFlowExpression
implements FlowExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$AbstractFlowExpression == null ? (class$openwfe$org$engine$expressions$AbstractFlowExpression = AbstractFlowExpression.class$("openwfe.org.engine.expressions.AbstractFlowExpression")) : class$openwfe$org$engine$expressions$AbstractFlowExpression).getName());
    private FlowExpressionId id = null;
    private FlowExpressionId parent = null;
    private String applyTime = null;
    private transient ApplicationContext applicationContext = null;
    private Map attributes = new HashMap(7);
    private FlowExpressionId envId = null;
    private ExpressionState state = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$AbstractFlowExpression;

    public FlowExpressionId getId() {
        return this.id;
    }

    public FlowExpressionId getParent() {
        return this.parent;
    }

    public String getApplyTime() {
        return this.applyTime;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public FlowExpressionId getEnvironmentId() {
        return this.envId;
    }

    public void setId(FlowExpressionId fei) {
        this.id = fei;
    }

    public void setParent(FlowExpressionId fei) {
        this.parent = fei;
    }

    public void setApplyTime(String isoDate) {
        this.applyTime = isoDate;
    }

    public void setAttributes(Map m) {
        this.attributes = m;
    }

    public void setEnvironmentId(FlowExpressionId fei) {
        this.envId = fei;
    }

    public void setApplicationContext(ApplicationContext ac) {
        this.applicationContext = ac;
    }

    public Class getExpressionClass() {
        return this.getClass();
    }

    public ApplicationContext context() {
        return this.applicationContext;
    }

    protected static boolean referencesNoVariable(String attributeValue) {
        return attributeValue == null || attributeValue.indexOf("${") < 0;
    }

    public String lookupAttribute(String attributeName, InFlowWorkItem wi) {
        String attributeValue = (String)this.attributes.get(attributeName);
        return this.substituteText(attributeValue, wi);
    }

    public String lookupAttribute(String attributeName, InFlowWorkItem wi, String defaultValue) {
        String s = this.lookupAttribute(attributeName, wi);
        if (s != null) {
            return s;
        }
        return defaultValue;
    }

    public String substituteText(String text, InFlowWorkItem wi) {
        log.debug((Object)("substituteText() text is    >" + text + "<"));
        if (AbstractFlowExpression.referencesNoVariable(text)) {
            return text;
        }
        VariableMap vMap = new VariableMap(this, wi);
        String s = Text.substitute((String)text, (Map)vMap);
        log.debug((Object)("substituteText() result is  >" + s + "<"));
        return s;
    }

    public void touchApplyTime() {
        this.setApplyTime(Time.toIsoDate());
    }

    public Object lookupVariable(String variableName) {
        if (this.getExpressionPool() == null) {
            return null;
        }
        return this.getExpressionPool().lookupVariable(this, variableName);
    }

    public void bindVariable(String variableName, Object value) {
        log.debug((Object)("bindVariable() '" + variableName + "' -> '" + value + "'"));
        log.debug((Object)("bindVariable() for " + this.getClass().getName() + "  " + this.getId()));
        if (this.getExpressionPool() == null) {
            return;
        }
        this.getExpressionPool().setVariable(this, variableName, value);
    }

    public void initWorkflowInstanceId(String workflowInstanceId) {
        if (this.parent != null) {
            this.parent.setWorkflowInstanceId(workflowInstanceId);
        }
        this.id.setWorkflowInstanceId(workflowInstanceId);
    }

    public String getAttributeValue(String attributeName) {
        return (String)this.attributes.get(attributeName);
    }

    public void tag(InFlowWorkItem wi) {
        if (wi == null) {
            log.warn((Object)("tag() wi is null ??? for " + this.getId()));
            return;
        }
        wi.setId(this.getId());
    }

    public void storeItself() {
        log.debug((Object)("storeItself() invoked for " + this.getId() + " (" + this.getClass().getName() + ")"));
        log.debug((Object)("storeItself() parent is " + this.getParent()));
        if (this.applicationContext == null || this.getExpressionPool() == null) {
            log.debug((Object)"storeItself() no applicationContext or expressionPool, cannot store.");
            return;
        }
        try {
            this.getExpressionPool().update(this);
        }
        catch (PoolException pe) {
            log.warn((Object)"storeItself() failure", (Throwable)((Object)pe));
        }
    }

    public ExpressionPool getExpressionPool() {
        return Definitions.getExpressionPool(this.applicationContext);
    }

    public ExpressionMap getExpressionMap() {
        return Definitions.getExpressionMap(this.applicationContext);
    }

    public ParticipantMap getParticipantMap() {
        return Definitions.getParticipantMap(this.applicationContext);
    }

    public Launcher getLauncher() {
        return Definitions.getLauncher(this.applicationContext);
    }

    private History getHistory() {
        return Definitions.getHistory(this.applicationContext);
    }

    public void historyLog(WorkItem wi, String eventCode, String participantName, String message) {
        History h = this.getHistory();
        if (h == null) {
            return;
        }
        h.log(this.getId(), wi, eventCode, participantName, message);
    }

    public InFlowWorkItem cancel() throws ApplyException {
        return null;
    }

    public void replyToParent(InFlowWorkItem wi) throws ReplyException {
        this.tag(wi);
        this.getExpressionPool().replyToParent(this, wi);
    }

    public void applyToParent(InFlowWorkItem wi) throws ApplyException {
        try {
            this.replyToParent(wi);
        }
        catch (ReplyException re) {
            throw new ApplyException("replyToParent() failed", (Throwable)((Object)re));
        }
    }

    public long getTimeSinceApplied() {
        try {
            return System.currentTimeMillis() - Time.fromIsoDate((String)this.applyTime);
        }
        catch (ParseException pe) {
            return 0L;
        }
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return super.hashCode();
    }

    public Object clone() {
        AbstractFlowExpression clone = (AbstractFlowExpression)ReflectionUtils.newInstance((Object)this);
        clone.setId(this.getId().copy());
        if (this.getEnvironmentId() != null) {
            clone.setEnvironmentId(this.getEnvironmentId().copy());
        }
        if (this.getParent() != null) {
            clone.setParent(this.getParent().copy());
        }
        clone.applicationContext = this.context();
        clone.setAttributes(Utils.copyHashMap((Map)this.getAttributes()));
        return clone;
    }

    public void init(ApplicationContext context, FlowExpressionId environmentId, FlowExpressionId parentId, FlowExpressionId id, RawExpression generatingExpression, Object raw, InFlowWorkItem currentWi) throws BuildException {
        this.setApplicationContext(context);
        this.setId(id);
        this.setParent(parentId);
        this.setEnvironmentId(environmentId);
        this.setAttributes(this.getLauncher().fetchAttributes(this, raw));
    }

    public ExpressionState getState() {
        return this.state;
    }

    public void setState(ExpressionState es) {
        this.state = es;
    }

    public Environment fetchEnvironment() {
        return (Environment)this.getExpressionPool().fetch(this.getEnvironmentId());
    }

    public Element dump() {
        Element elt = new Element("expression");
        elt.setAttribute("class", this.getClass().getName());
        elt.setAttribute("id", this.getId().toString());
        return elt;
    }

    public void debugDump() {
        StringBuffer sb = new StringBuffer();
        sb.append("debugDump()  ").append(this.getClass().getName()).append("\n").append("   ").append(this.getId().toString()).append("\n").append("   attributes :\n");
        Iterator it = this.getAttributes().keySet().iterator();
        while (it.hasNext()) {
            String k = (String)it.next();
            String v = this.getAttributes().get(k).toString();
            sb.append("     - '").append(k).append("' -->  >").append(v).append("<\n");
        }
        log.debug((Object)sb.toString());
    }

    public void xmlDebugDump(String methodName) {
        try {
            log.debug((Object)(methodName + "()\n" + XmlCoder.encodeToString((Object)this, null)));
        }
        catch (Throwable t) {
            log.debug((Object)(methodName + "() failure in xmlDebugDump()"), t);
        }
    }

    public static List deepCopy(List source) {
        if (source == null) {
            return new ArrayList(0);
        }
        ArrayList<Object> result = new ArrayList<Object>(source.size());
        Iterator it = source.iterator();
        while (it.hasNext()) {
            result.add(((FlowExpressionId)it.next()).clone());
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

