/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.IfExpression;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class CaseExpression
extends IfExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$CaseExpression == null ? (class$openwfe$org$engine$expressions$CaseExpression = CaseExpression.class$("openwfe.org.engine.expressions.CaseExpression")) : class$openwfe$org$engine$expressions$CaseExpression).getName());
    private int currentId = -1;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$CaseExpression;

    public int getCurrentId() {
        return this.currentId;
    }

    public void setCurrentId(int i) {
        this.currentId = i;
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        log.debug((Object)"apply()");
        if (this.getChildren() == null || this.getChildren().size() < 1) {
            this.applyToParent(wi);
            return;
        }
        this.setCurrentId(0);
        this.storeItself();
        this.getExpressionPool().apply((FlowExpressionId)this.getChildren().get(this.getCurrentId()), wi);
    }

    public void reply(InFlowWorkItem wi) throws ReplyException {
        if (this.isConditionTreated()) {
            log.debug((Object)"reply() case solved.");
            this.replyToParent(wi);
            return;
        }
        log.debug((Object)("reply() expressionId is " + this.getId().getExpressionId() + ", currentId is " + this.getCurrentId() + ", children.size() is " + this.getChildren().size()));
        if (this.getCurrentId() + 1 >= this.getChildren().size()) {
            log.debug((Object)"reply() no more children, replying to parent.");
            this.replyToParent(wi);
            return;
        }
        boolean booleanResult = ValueUtils.lookupBooleanResult(wi);
        if (booleanResult) {
            this.setConditionTreated(true);
            this.setCurrentId(this.getCurrentId() + 1);
        } else {
            this.removeBranch(this.getCurrentId() + 1);
            if (this.getCurrentId() + 2 >= this.getChildren().size()) {
                log.debug((Object)"reply() no 'over-next' child, replying to parent.");
                this.replyToParent(wi);
                return;
            }
            this.setCurrentId(this.getCurrentId() + 2);
        }
        this.storeItself();
        try {
            log.debug((Object)("reply() eval child index " + this.getCurrentId()));
            this.getExpressionPool().apply((FlowExpressionId)this.getChildren().get(this.getCurrentId()), wi);
        }
        catch (ApplyException ae) {
            throw new ReplyException("Failed to apply child expression at index " + this.getCurrentId(), (Throwable)((Object)ae));
        }
    }

    protected void removeRemainingBranches() {
        for (int i = this.getCurrentId() + 1; i < this.getChildren().size(); ++i) {
            this.removeBranch(i);
        }
    }

    public void replyToParent(InFlowWorkItem wi) throws ReplyException {
        this.removeRemainingBranches();
        super.replyToParent(wi);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

