/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.ArrayList;
import java.util.Iterator;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.expressions.AbstractFlowExpression;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;
import openwfe.org.engine.expressions.DefinitionExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.raw.RawExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class DefineExpression
extends CleanCompositeFlowExpression
implements DefinitionExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$DefineExpression == null ? (class$openwfe$org$engine$expressions$DefineExpression = DefineExpression.class$("openwfe.org.engine.expressions.DefineExpression")) : class$openwfe$org$engine$expressions$DefineExpression).getName());
    public static final String A_MAP_CHILDREN = "map-children";
    static /* synthetic */ Class class$openwfe$org$engine$expressions$DefineExpression;

    public Object eval(InFlowWorkItem wi) throws ApplyException {
        String sChildrenToMap = (String)this.getAttributes().get(A_MAP_CHILDREN);
        log.debug((Object)("eval() sChildrenToMap >" + sChildrenToMap + "<"));
        AbstractFlowExpression body = null;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            FlowExpressionId fei = (FlowExpressionId)it.next();
            RawExpression exp = (RawExpression)this.getExpressionPool().fetch(fei);
            log.debug((Object)("eval() child is " + fei));
            if (!exp.isDefinition()) {
                if (body != null) continue;
                body = exp;
                body.getAttributes().put(A_MAP_CHILDREN, sChildrenToMap);
                continue;
            }
            try {
                this.define(exp, wi);
            }
            catch (BuildException be) {
                throw new ApplyException("Failed to bind definition", (Throwable)((Object)be));
            }
        }
        if (body == null) {
            throw new ApplyException("No body for definition " + this.getId());
        }
        log.debug((Object)("eval() body is " + body.getId()));
        return body.getId();
    }

    private void define(RawExpression re, InFlowWorkItem wi) throws BuildException, ApplyException {
        String name = re.getDefinitionName();
        log.debug((Object)("define() name >" + name + "<"));
        Object oTemplate = null;
        if (name != null && name.startsWith("//") && (class$openwfe$org$engine$expressions$DefineExpression == null ? (class$openwfe$org$engine$expressions$DefineExpression = DefineExpression.class$("openwfe.org.engine.expressions.DefineExpression")) : class$openwfe$org$engine$expressions$DefineExpression).isAssignableFrom(re.getExpressionClass())) {
            oTemplate = re.clone();
        } else {
            DefinitionExpression de = (DefinitionExpression)((Object)re.resolveExpression(wi));
            oTemplate = de.eval(wi);
        }
        if (name != null && oTemplate != null) {
            this.bindVariable(name, oTemplate);
        } else {
            log.warn((Object)("define() missing name or ref for definition at  " + this.getId()));
        }
        this.getExpressionPool().removeExpression(re.getId());
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        FlowExpressionId fei = (FlowExpressionId)this.eval(wi);
        this.setChildren(new ArrayList(1));
        this.getChildren().add(fei);
        String message = "launching";
        if (this.getParent() != null) {
            message = "launching sub";
        }
        this.historyLog(wi, "+STA", null, message);
        wi.addHistoryItem(this.getId(), this.getClass().getName(), message);
        this.getExpressionPool().apply(fei, wi);
    }

    public void reply(InFlowWorkItem wi) throws ReplyException {
        this.historyLog(wi, "+END", null, "replying");
        if (this.getParent() != null) {
            this.replyToParent(wi);
        } else {
            this.getExpressionPool().removeExpression(this);
        }
    }

    public void init(ApplicationContext context, FlowExpressionId environmentId, FlowExpressionId parentId, FlowExpressionId id, RawExpression generatingExpression, Object raw, InFlowWorkItem currentWi) throws BuildException {
        super.init(context, environmentId, parentId, id, generatingExpression, raw, currentWi);
        if (this.getChildren() == null) {
            return;
        }
        int bodyCount = 0;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof FlowExpressionId)) continue;
            FlowExpressionId fei = (FlowExpressionId)child;
            Class childClass = this.getExpressionMap().getClass(fei.getExpressionName());
            if (childClass == null) {
                log.warn((Object)("init() " + id.getExpressionName() + " unknown expression '" + fei.getExpressionName() + "'"));
                continue;
            }
            if (!(class$openwfe$org$engine$expressions$DefineExpression == null ? DefineExpression.class$("openwfe.org.engine.expressions.DefineExpression") : class$openwfe$org$engine$expressions$DefineExpression).isAssignableFrom(childClass)) {
                ++bodyCount;
            }
            if (bodyCount <= 1) continue;
            log.warn((Object)("init() " + id.getExpressionName() + " with more than one body"));
            break;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

