/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.BuildException;
import openwfe.org.engine.expressions.EngineEnvironmentId;
import openwfe.org.engine.expressions.ExpressionToUnbind;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class Environment
extends ZeroChildExpression
implements ExpressionToUnbind {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$Environment == null ? (class$openwfe$org$engine$expressions$Environment = Environment.class$("openwfe.org.engine.expressions.Environment")) : class$openwfe$org$engine$expressions$Environment).getName());
    public static final String EXPRESSION_NAME = "__env__";
    private Map variables = new LinkedHashMap();
    private List cachedKeySet = null;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$Environment;

    public static Environment generateEnvironment(FlowExpression generatingExpression) throws BuildException, PoolException {
        log.debug((Object)("generateEnvironment() for " + generatingExpression.getId() + "  (" + generatingExpression.getClass().getName() + ")"));
        Environment env = new Environment();
        FlowExpressionId id = generatingExpression.getId().copy();
        id.setExpressionId(id.getExpressionId() + "e");
        id.setExpressionName(EXPRESSION_NAME);
        env.setApplicationContext(generatingExpression.context());
        env.setEnvironmentId(generatingExpression.getEnvironmentId());
        log.debug((Object)("generateEnvironment() -1 env.id =     " + env.getId()));
        log.debug((Object)("generateEnvironment() -1 env.parent = " + env.getParent()));
        log.debug((Object)("generateEnvironment() -1 env.envId =  " + env.getEnvironmentId()));
        if (generatingExpression.getParent() != null) {
            ExpressionPool expool = Definitions.getExpressionPool(generatingExpression.context());
            env.setEnvironmentId(expool.getEnvironmentId(generatingExpression.getParent()));
        }
        env.setId(id);
        log.debug((Object)("generateEnvironment()  0 env.id =    " + env.getId()));
        log.debug((Object)("generateEnvironment()  0 env.envId = " + env.getEnvironmentId()));
        env.getExpressionPool().add(env);
        generatingExpression.setEnvironmentId(env.getId());
        log.debug((Object)("generateEnvironment()  1 env.id =    " + env.getId()));
        log.debug((Object)("generateEnvironment()  1 env.envId = " + env.getEnvironmentId()));
        return env;
    }

    public synchronized void unbind() throws PoolException {
        Iterator it = this.variables.values().iterator();
        while (it.hasNext()) {
            Object v = it.next();
            if (v instanceof ExpressionToUnbind) {
                try {
                    ((FlowExpression)v).setApplicationContext(this.context());
                    ((ExpressionToUnbind)v).unbind();
                }
                catch (PoolException pe) {
                    log.warn((Object)"unbind() problem. Resuming anyway.", (Throwable)((Object)pe));
                }
                continue;
            }
            if (!(v instanceof FlowExpressionId)) continue;
            this.getExpressionPool().removeExpression((FlowExpressionId)v);
        }
        log.debug((Object)"unbind() done.");
    }

    public synchronized Object get(String variableName) {
        Class c;
        log.debug((Object)("get() in " + this.getId() + " for '" + variableName + "'"));
        if (this.cachedKeySet == null) {
            this.cachedKeySet = new ArrayList(this.variables.keySet());
            Collections.reverse(this.cachedKeySet);
        }
        Iterator it = this.cachedKeySet.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.matches(variableName)) continue;
            return this.variables.get(key);
        }
        if (this.getId().equals(EngineEnvironmentId.ID) && (c = Definitions.getExpressionMap(this.context()).getClass(variableName)) != null) {
            return c;
        }
        log.debug((Object)("get() for '" + variableName + "'. Not found in " + this.getId()));
        return null;
    }

    public Object lookup(String variableName) {
        log.debug((Object)("lookup() in " + this.getId() + " for '" + variableName + "'"));
        Object result = this.get(variableName);
        if (result != null) {
            return result;
        }
        if (this.getEnvironmentId() == null) {
            log.debug((Object)"lookup() having to lookup in engine env...");
            return this.getExpressionPool().fetchEngineEnvironment().get(variableName);
        }
        Environment env = (Environment)this.getExpressionPool().fetch(this.getEnvironmentId());
        if (env == null) {
            log.warn((Object)("lookup() didn't find an env at  " + this.getEnvironmentId()));
            return this.getExpressionPool().fetchEngineEnvironment().get(variableName);
        }
        return env.lookup(variableName);
    }

    public Environment lookupContainingEnvironment(String variableName) {
        if (this.variables.containsKey(variableName)) {
            return this;
        }
        if (this.getId().equals(EngineEnvironmentId.ID)) {
            return null;
        }
        Environment env = (Environment)this.getExpressionPool().fetch(this.getEnvironmentId());
        if (env == null) {
            log.debug((Object)("lookupContainingEnvironment() did not find env  " + this.getEnvironmentId()));
            return null;
        }
        return env.lookupContainingEnvironment(variableName);
    }

    public synchronized void put(String variableName, Object value) {
        this.variables.put(variableName, value);
        this.cachedKeySet = null;
        this.storeItself();
        log.debug((Object)("put() '" + variableName + "' in " + this.getId()));
        if (value != null) {
            log.debug((Object)("put() '" + variableName + "' -> " + value.toString()));
        }
    }

    public void putAll(Map m) {
        log.debug((Object)("putAll() in env  " + this.getId()));
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = m.get(key);
            log.debug((Object)("putAll() '" + key + "' -> '" + value + "'"));
            this.put(key, value);
        }
    }

    public void reattach(FlowExpressionId newOwnerId) {
        this.getExpressionPool().removeExpression(this.getId());
        this.setId(newOwnerId.copy());
        this.getId().setExpressionName(EXPRESSION_NAME);
        if (!this.getId().getExpressionId().endsWith("e")) {
            this.getId().setExpressionId(this.getId().getExpressionId() + "e");
        }
        log.debug((Object)("reattach() new id  " + this.getId()));
        this.storeItself();
    }

    public Map getVariables() {
        return this.variables;
    }

    public void setVariables(Map m) {
        this.variables = (LinkedHashMap)m;
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
    }

    public static boolean ownsEnvironment(FlowExpression fe) {
        FlowExpressionId expId = fe.getId().copy();
        FlowExpressionId envId = fe.getEnvironmentId();
        expId.setExpressionId(expId.getExpressionId() + "e");
        expId.setExpressionName(EXPRESSION_NAME);
        return expId.equals(envId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

