/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.ValueException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.expressions.WithChildren;
import openwfe.org.engine.expressions.ZeroChildExpression;
import openwfe.org.engine.expressions.xeme.XemeUtils;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.CollectionAttribute;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.XmlAttribute;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class GetValueExpression
extends ZeroChildExpression
implements WithChildren {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$GetValueExpression == null ? (class$openwfe$org$engine$expressions$GetValueExpression = GetValueExpression.class$("openwfe.org.engine.expressions.GetValueExpression")) : class$openwfe$org$engine$expressions$GetValueExpression).getName());
    static /* synthetic */ Class class$openwfe$org$engine$expressions$GetValueExpression;

    public void apply(InFlowWorkItem wi) throws ApplyException {
        String expressionName = this.getId().getExpressionName();
        String key = this.lookupAttribute("__value__", wi);
        Object value = null;
        if (expressionName.startsWith("q")) {
            value = this.handleQuote(wi, key);
        } else if (expressionName.startsWith("a")) {
            value = this.handleAttribute(wi, key);
        } else if (key != null) {
            if (expressionName.startsWith("v")) {
                value = this.handleVariable(wi, key);
            } else if (expressionName.startsWith("f")) {
                value = this.handleField(wi, key);
            }
        }
        if (value != null) {
            if (value instanceof Attribute) {
                ValueUtils.setResult(wi, value);
            } else {
                ValueUtils.setResult(wi, new XmlAttribute((Content)value));
            }
        } else {
            ValueUtils.cleanResult(wi);
        }
        this.applyToParent(wi);
    }

    protected Content handleVariable(InFlowWorkItem wi, String key) {
        Object o = this.lookupVariable(key);
        log.debug((Object)("handleVariable() key         >" + key + "<"));
        log.debug((Object)("handleVariable() input       >" + o + "<"));
        if (o != null) {
            log.debug((Object)("handleVariable() input.class " + o.getClass().getName()));
        }
        Content c = XemeUtils.toXemeResult(this, o);
        log.debug((Object)("handleVariable() result is\n" + XmlUtils.xmlToString((Content)c)));
        return c;
    }

    protected Content handleField(InFlowWorkItem wi, String key) {
        Attribute a = CollectionAttribute.lookupAttribute(key, wi.getAttributes());
        return XemeUtils.toXemeResult(this, a);
    }

    protected Attribute handleAttribute(InFlowWorkItem wi, String key) {
        Attribute value = null;
        try {
            value = ValueUtils.determineWorkitemFragment(this, wi);
        }
        catch (ValueException e) {
            log.debug((Object)"handleAttribute() failed to fetch workitem fragment", (Throwable)((Object)e));
        }
        if (value == null) {
            value = ValueUtils.getResult(wi);
        }
        return value;
    }

    public Content handleQuote(InFlowWorkItem wi, String key) {
        String sContent = this.lookupAttribute("__content__", wi);
        if (sContent != null) {
            log.debug((Object)("handleQuote() content >" + sContent + "<"));
            try {
                Element eQuote = XmlUtils.extractXmlElement((String)sContent);
                for (int i = 0; i < eQuote.getContent().size(); ++i) {
                    Content c = (Content)eQuote.getContent().get(i);
                    if (c instanceof Text && ((Text)c).getTextTrim().equals("")) continue;
                    return c;
                }
            }
            catch (Exception e) {
                log.debug((Object)"handleQuote() failed to extract quoted XML", (Throwable)e);
                log.warn((Object)("handleQuote() failed to extract quoted XML " + e));
            }
            if (sContent.trim().length() > 0) {
                return XemeUtils.toXemeResult(this, sContent.trim());
            }
        }
        return XemeUtils.toXemeResult(this, key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

