/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.expressions;

import openwfe.org.OpenWfeException;
import openwfe.org.engine.expressions.ApplyException;
import openwfe.org.engine.expressions.CleanCompositeFlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.expressions.ReplyException;
import openwfe.org.engine.expressions.ValueUtils;
import openwfe.org.engine.impl.functions.BasicFunctions;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public class IfExpression
extends CleanCompositeFlowExpression {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$expressions$IfExpression == null ? (class$openwfe$org$engine$expressions$IfExpression = IfExpression.class$("openwfe.org.engine.expressions.IfExpression")) : class$openwfe$org$engine$expressions$IfExpression).getName());
    public static final String A_TEST = "test";
    private int childOffset = 1;
    private boolean conditionTreated = false;
    static /* synthetic */ Class class$openwfe$org$engine$expressions$IfExpression;

    public boolean isConditionTreated() {
        return this.conditionTreated;
    }

    public void setConditionTreated(boolean b) {
        this.conditionTreated = b;
    }

    public void apply(InFlowWorkItem wi) throws ApplyException {
        String test = this.lookupAttribute(A_TEST, wi);
        if (test == null) {
            FlowExpressionId next = (FlowExpressionId)this.getChildren().get(0);
            this.getExpressionPool().apply(next, wi);
            return;
        }
        this.childOffset = 0;
        try {
            this.applyConsequence(this.evalTest(test), wi);
        }
        catch (OpenWfeException e) {
            if (e instanceof ApplyException) {
                throw (ApplyException)e;
            }
            throw new ApplyException("failed to apply (shortcutted) consequence", e);
        }
    }

    protected boolean evalTest(String test) {
        return BasicFunctions.eval(test);
    }

    public void reply(InFlowWorkItem wi) throws ReplyException {
        if (this.conditionTreated) {
            log.debug((Object)"reply() condition treated. Replying to parent.");
            log.debug((Object)("reply() parent is  " + this.getParent()));
            this.replyToParent(wi);
            return;
        }
        boolean booleanResult = ValueUtils.lookupBooleanResult(wi);
        try {
            this.applyConsequence(booleanResult, wi);
        }
        catch (OpenWfeException e) {
            if (e instanceof ReplyException) {
                throw (ReplyException)e;
            }
            throw new ReplyException("Failed to trigger consequence", e);
        }
    }

    protected void applyConsequence(boolean booleanResult, InFlowWorkItem wi) throws OpenWfeException {
        FlowExpressionId next = null;
        FlowExpressionId alternative = null;
        FlowExpressionId thenChild = null;
        if (this.getChildren().size() > this.childOffset) {
            thenChild = (FlowExpressionId)this.getChildren().get(this.childOffset);
        }
        FlowExpressionId elseChild = null;
        if (this.getChildren().size() > this.childOffset + 1) {
            elseChild = (FlowExpressionId)this.getChildren().get(this.childOffset + 1);
        }
        if (booleanResult) {
            next = thenChild;
            alternative = elseChild;
        } else {
            next = elseChild;
            alternative = thenChild;
        }
        this.conditionTreated = true;
        this.storeItself();
        this.removeBranch(alternative);
        if (next != null) {
            this.getExpressionPool().apply(next, wi);
        } else {
            this.replyToParent(wi);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

