/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.dispatch;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.engine.dispatch.AbstractWorkItemDispatcher;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.engine.workitem.WorkItemCoder;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public class FileDispatcher
extends AbstractWorkItemDispatcher {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$dispatch$FileDispatcher == null ? (class$openwfe$org$engine$impl$dispatch$FileDispatcher = FileDispatcher.class$("openwfe.org.engine.impl.dispatch.FileDispatcher")) : class$openwfe$org$engine$impl$dispatch$FileDispatcher).getName());
    public static final String DIRECTORY = "directory";
    private String directory = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$dispatch$FileDispatcher;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.directory = (String)serviceParams.get(DIRECTORY);
        if (!this.directory.startsWith(File.separator)) {
            this.directory = context.getApplicationDirectory() + this.directory;
        }
        if (!this.directory.endsWith(File.separator)) {
            this.directory = this.directory + File.separator;
        }
    }

    public Object dispatch(WorkItem wi) throws DispatchingException {
        String fileName = null;
        if (wi instanceof InFlowWorkItem) {
            FlowExpressionId id = ((InFlowWorkItem)wi).getLastExpressionId();
            fileName = this.directory + id.getWorkflowDefinitionName() + "--" + id.getWorkflowDefinitionRevision() + "--" + id.getWorkflowInstanceId() + "--" + id.getExpressionName() + "--" + id.getExpressionId() + ".xml";
        }
        if (wi instanceof LaunchItem) {
            LaunchItem li = (LaunchItem)wi;
            int i = 0;
            while (new File(fileName = this.directory + "launch-item--" + i + ".xml").exists()) {
                ++i;
            }
        }
        try {
            WorkItemCoder coder = this.instantiateEncoder();
            FileOutputStream fos = new FileOutputStream(fileName);
            if (wi instanceof InFlowWorkItem) {
                ((InFlowWorkItem)wi).setDispatchTime(Time.toIsoDate());
            }
            byte[] encodedWorkItem = (byte[])coder.encode(wi, this.getContext(), this.getParams());
            fos.write(encodedWorkItem);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new DispatchingException("Dispatching failed for " + wi.toString(), e);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

