/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.expool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.engine.expool.PoolException;
import openwfe.org.engine.expressions.EngineEnvironmentId;
import openwfe.org.engine.expressions.Environment;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.expool.ExpoolUtils;
import openwfe.org.engine.impl.expool.SimpleExpressionPool;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class InMemoryExpressionPool
extends SimpleExpressionPool {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$expool$InMemoryExpressionPool == null ? (class$openwfe$org$engine$impl$expool$InMemoryExpressionPool = InMemoryExpressionPool.class$("openwfe.org.engine.impl.expool.InMemoryExpressionPool")) : class$openwfe$org$engine$impl$expool$InMemoryExpressionPool).getName());
    private Map expressionMap = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$expool$InMemoryExpressionPool;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        try {
            this.reload();
        }
        catch (PoolException pe) {
            log.warn((Object)"init() reload() failed, resuming with an empty expression pool. No flow instance could be rebuilt", (Throwable)((Object)pe));
        }
    }

    public void add(FlowExpression fe) throws PoolException {
        log.debug((Object)("add() " + fe.getId()));
        fe.setApplicationContext(this.getContext());
        this.expressionMap.put(fe.getId(), fe);
        if (this.getStore() != null) {
            this.getStore().storeExpression(fe);
        }
    }

    public int size() {
        return this.expressionMap.size();
    }

    public void update(FlowExpression fe) throws PoolException {
        this.add(fe);
    }

    public Environment fetchEngineEnvironment() {
        Environment result = (Environment)this.fetch(EngineEnvironmentId.ID);
        if (result == null) {
            if (this.getStore() == null) {
                Environment ee = new Environment();
                ee.setId(EngineEnvironmentId.ID);
                ee.setApplicationContext(this.getContext());
                this.expressionMap.put(ee.getId(), ee);
                return ee;
            }
            result = this.getStore().loadEngineEnvironment();
            try {
                this.update(result);
            }
            catch (PoolException pe) {
                log.warn((Object)"Failed to store Engine Environment.", (Throwable)((Object)pe));
            }
        }
        return result;
    }

    public FlowExpression fetch(FlowExpressionId fei) {
        log.debug((Object)("fetch() for " + fei));
        return (FlowExpression)this.expressionMap.get(fei);
    }

    public void removeExpression(FlowExpression fe) {
        this.expressionMap.remove(fe.getId());
        super.removeExpression(fe);
    }

    public boolean isActive(FlowExpressionId fei) {
        return this.expressionMap.get(fei) != null;
    }

    public Iterator contentIterator(Class assignClass) {
        ArrayList<FlowExpression> result = new ArrayList<FlowExpression>(this.expressionMap.size());
        Iterator it = this.expressionMap.values().iterator();
        while (it.hasNext()) {
            FlowExpression fe = (FlowExpression)it.next();
            if (!ExpoolUtils.isAssignableFromClass(fe, assignClass)) continue;
            result.add(fe);
        }
        log.debug((Object)("contentIterator() found " + result.size() + " matching expressions"));
        return result.iterator();
    }

    protected void reload() throws PoolException {
        this.expressionMap = new HashMap(10000);
        if (this.getStore() != null) {
            this.getStore().loadAll(this.expressionMap);
        } else {
            log.info((Object)("reload() no store attached to " + this.getClass().getName()));
        }
        log.info((Object)("reload() done. Reloaded " + this.expressionMap.size() + " expressions."));
    }

    public Element getStatus() {
        Element result = new Element(this.getName());
        result.addContent((Content)XmlUtils.getClassElt((Service)this));
        result.addContent((Content)XmlUtils.getRevisionElt((String)"$Id: InMemoryExpressionPool.java 2321 2006-02-03 20:59:14Z jmettraux $"));
        Element pecElt = new Element("pooledExpressionCount");
        pecElt.addContent("" + this.expressionMap.size());
        result.addContent((Content)pecElt);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

