/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.functions;

import java.util.Random;
import openwfe.org.Utils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expool.ExpressionPool;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.impl.functions.NumericFunctions;
import openwfe.org.engine.impl.functions.StringList;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public abstract class BasicFunctions {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$functions$BasicFunctions == null ? (class$openwfe$org$engine$impl$functions$BasicFunctions = BasicFunctions.class$("openwfe.org.engine.impl.functions.BasicFunctions")) : class$openwfe$org$engine$impl$functions$BasicFunctions).getName());
    static /* synthetic */ Class class$openwfe$org$engine$impl$functions$BasicFunctions;

    public static String attributeCount(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return "" + wi.getAttributes().size();
    }

    public static String fieldCount(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return "" + wi.getAttributes().size();
    }

    public static String sum(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return NumericFunctions.add(fe, wi, args);
    }

    public static String car(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        StringList sl = new StringList(fe, wi, args);
        return sl.car();
    }

    public static String cdr(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        StringList sl = new StringList(fe, wi, args);
        return sl.cdr();
    }

    public static String cons(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args == null || args.length < 2) {
            return "";
        }
        String newElt = args[0];
        StringList sl = new StringList(fe, wi, args, 1, 2);
        String result = sl.cons(newElt);
        return result;
    }

    public static String llen(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return "" + new StringList(fe, wi, args).size();
    }

    public static String list(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return new StringList(fe, wi, args).toString();
    }

    public static String elt(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args == null || args.length < 2) {
            return "";
        }
        int index = Integer.parseInt(args[0]);
        StringList sl = new StringList(fe, wi, args, 1, 2);
        return sl.elt(index);
    }

    public static String shuffle(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        StringList sl = new StringList(fe, wi, args);
        return sl.toString();
    }

    public static String reverse(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        StringList sl = new StringList(fe, wi, args);
        sl.reverse();
        return sl.toString();
    }

    public static String sort(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        StringList sl = new StringList(fe, wi, args);
        sl.sort();
        log.debug((Object)("sort() result is >" + sl.toString() + "<"));
        return sl.toString();
    }

    public static String len(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length < 1) {
            return "0";
        }
        return "" + args[0].length();
    }

    public static String substring(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length < 1) {
            return "";
        }
        String s = args[0];
        if (s.length() == 0) {
            return "";
        }
        int i = 0;
        int j = s.length();
        if (args.length > 1) {
            i = Integer.parseInt(args[1]);
        }
        if (args.length > 2) {
            j = Integer.parseInt(args[2]);
        }
        if (i < 0) {
            i = s.length() + i;
        }
        if (j < 0) {
            j = s.length() + j;
        }
        return s.substring(i, j);
    }

    public static String rlong(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        Random gen = new Random(System.currentTimeMillis());
        return "" + gen.nextLong();
    }

    public static String rint(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        Random gen = new Random(System.currentTimeMillis());
        return "" + gen.nextInt();
    }

    public static String rdouble(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        Random gen = new Random(System.currentTimeMillis());
        return "" + gen.nextDouble();
    }

    public static String range(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        int start = 0;
        int count = 0;
        int increment = 1;
        try {
            if (args.length < 1) {
                return "";
            }
            if (args.length == 1) {
                count = Integer.parseInt(args[0]);
            } else if (args.length == 2) {
                start = Integer.parseInt(args[0]);
                count = Integer.parseInt(args[1]);
            } else {
                start = Integer.parseInt(args[0]);
                count = Integer.parseInt(args[1]);
                increment = Integer.parseInt(args[2]);
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("" + start);
                start += increment;
            }
            return sb.toString();
        }
        catch (NumberFormatException nfe) {
            return "";
        }
    }

    public static String wfid(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return fe.getId().getWorkflowInstanceId();
    }

    public static String fei(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return fe.getId().toString();
    }

    public static String wfdname(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return fe.getId().getWorkflowDefinitionName();
    }

    public static String wfdrevision(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return fe.getId().getWorkflowDefinitionRevision();
    }

    public static String eval(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length < 1) {
            return "false";
        }
        String s = args[0].trim().toLowerCase();
        log.debug((Object)("eval(fe, wi, args) s is >" + s + "<"));
        if (s.equals("true")) {
            return "true";
        }
        if (s.equals("false")) {
            return "false";
        }
        return "" + BasicFunctions.eval(args[0]);
    }

    public static boolean eval(String test) {
        log.debug((Object)("eval(t) test >" + test + "<"));
        boolean equality = true;
        int i = test.indexOf("==");
        int j = test.indexOf("!=");
        int k = test.indexOf(">");
        int l = test.indexOf("<");
        if (l > -1) {
            k = l;
        }
        log.debug((Object)("eval(t) k is " + k));
        if (k > -1) {
            return BasicFunctions.evalInequality(k, test);
        }
        if (j > -1) {
            i = j;
            equality = false;
        }
        if (i < 0) {
            return test.trim().toLowerCase().equals("true");
        }
        if (i + 2 >= test.length()) {
            return false;
        }
        String sLeft = test.substring(0, i).trim();
        String sRight = test.substring(i + 2).trim();
        boolean eqResult = sLeft.equals(sRight);
        if (equality) {
            return eqResult;
        }
        return !eqResult;
    }

    private static boolean evalInequality(int operatorIndex, String test) {
        if (operatorIndex >= test.length() - 1) {
            return false;
        }
        boolean greaterThan = test.charAt(operatorIndex) == '>';
        boolean orEquals = test.charAt(operatorIndex + 1) == '=';
        log.debug((Object)("evalInequality() greaterThan  : " + greaterThan));
        log.debug((Object)("evalInequality() orEquals     : " + orEquals));
        if (orEquals && operatorIndex == test.length() - 2) {
            return false;
        }
        int offset = 2;
        if (orEquals) {
            offset = 3;
        }
        String sLeft = test.substring(0, operatorIndex).trim();
        String sRight = test.substring(operatorIndex + offset).trim();
        log.debug((Object)("evalInequality() left   >" + sLeft + "<"));
        log.debug((Object)("evalInequality() right  >" + sRight + "<"));
        int c = Utils.compareValues((Object)sLeft, (Object)sRight);
        log.debug((Object)("evalInequality() c is " + c));
        if (!greaterThan) {
            c = -1 * c;
        }
        log.debug((Object)("evalInequality() c is " + c));
        if (orEquals) {
            return c >= 0;
        }
        return c > 0;
    }

    public static String hashcode(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length < 1) {
            return "";
        }
        return "" + args[0].hashCode();
    }

    public static String tsm(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return BasicFunctions.testandsetmutex(fe, wi, args);
    }

    public static synchronized String testandsetmutex(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        String mutexName = "/__mutex__";
        if (args.length > 0) {
            mutexName = args[0];
        }
        log.debug((Object)("tsm() mutex name >" + mutexName + "< for " + fe.getId()));
        Boolean b = (Boolean)BasicFunctions.getExpressionPool(fe).lookupVariable(fe, mutexName);
        if (b == null) {
            BasicFunctions.getExpressionPool(fe).setVariable(fe, mutexName, Boolean.TRUE);
            log.debug((Object)"tsm() returning 'true'");
            return "true";
        }
        return "false";
    }

    public static ExpressionPool getExpressionPool(FlowExpression fe) {
        return Definitions.getExpressionPool(fe.context());
    }

    public static String d_debugargs(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            sb.append("|").append(args[i]).append("| ");
        }
        String result = sb.toString().trim();
        log.debug((Object)("debugargs() result >" + result + "<"));
        return result;
    }

    public static String d_expoolsize(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return "" + BasicFunctions.getExpressionPool(fe).size();
    }

    public static String lowercase(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length > 0) {
            return args[0].toLowerCase();
        }
        return "";
    }

    public static String lc(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return BasicFunctions.lowercase(fe, wi, args);
    }

    public static String uppercase(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length > 0) {
            return args[0].toUpperCase();
        }
        return "";
    }

    public static String uc(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return BasicFunctions.uppercase(fe, wi, args);
    }

    public static String matches(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length < 2) {
            return "false";
        }
        return "" + args[0].matches(args[1]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

