/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.functions;

import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public abstract class BooleanFunctions {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$functions$BooleanFunctions == null ? (class$openwfe$org$engine$impl$functions$BooleanFunctions = BooleanFunctions.class$("openwfe.org.engine.impl.functions.BooleanFunctions")) : class$openwfe$org$engine$impl$functions$BooleanFunctions).getName());
    public static final String S_TRUE = "true";
    public static final String S_FALSE = "false";
    static /* synthetic */ Class class$openwfe$org$engine$impl$functions$BooleanFunctions;

    public static String not(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length < 1) {
            log.debug((Object)"not() no args : returning false.");
            return S_FALSE;
        }
        log.debug((Object)("not() args[0] is '" + args[0] + "'"));
        return BooleanFunctions.toString(!BooleanFunctions.toBoolean(args[0]));
    }

    public static String and(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length < 1) {
            return S_FALSE;
        }
        for (int i = 0; i < args.length; ++i) {
            if (BooleanFunctions.toBoolean(args[i])) continue;
            return S_FALSE;
        }
        return S_TRUE;
    }

    public static String or(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length < 1) {
            return S_FALSE;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!BooleanFunctions.toBoolean(args[i])) continue;
            return S_TRUE;
        }
        return S_FALSE;
    }

    public static String xor(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length < 2) {
            return S_FALSE;
        }
        if (BooleanFunctions.toBoolean(args[0]) ^ BooleanFunctions.toBoolean(args[1])) {
            return S_TRUE;
        }
        return S_FALSE;
    }

    public static boolean toBoolean(String s) {
        if (s == null) {
            return false;
        }
        log.debug((Object)("toBoolean() interpreting >" + s.trim().toLowerCase() + "<"));
        return s.trim().toLowerCase().equals(S_TRUE);
    }

    public static String toString(boolean b) {
        if (b) {
            return S_TRUE;
        }
        return S_FALSE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

