/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.functions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public abstract class DateTimeFunctions {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$functions$DateTimeFunctions == null ? (class$openwfe$org$engine$impl$functions$DateTimeFunctions = DateTimeFunctions.class$("openwfe.org.engine.impl.functions.DateTimeFunctions")) : class$openwfe$org$engine$impl$functions$DateTimeFunctions).getName());
    private static SimpleDateFormat ts_shortSdf = new SimpleDateFormat("yyyyMMdd");
    private static SimpleDateFormat ts_longSdf = new SimpleDateFormat("yyyyMMddhhmmss");
    private static SimpleDateFormat ts_veryLongSdf = new SimpleDateFormat("yyyyMMddhhmmssSSS");
    static /* synthetic */ Class class$openwfe$org$engine$impl$functions$DateTimeFunctions;

    public static String now(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return Time.toIsoDate();
    }

    public static String today(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        String sNow = Time.toIsoDate();
        int i = sNow.indexOf(" ");
        return sNow.substring(0, i);
    }

    public static String toIsoDate(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length < 1) {
            return Time.toIsoDate();
        }
        if (args.length > 1) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(args[1]);
                Date d = sdf.parse(args[0]);
                return Time.toIsoDate((long)d.getTime());
            }
            catch (Throwable t) {
                return "cannot parse date '" + args[0] + "' with format '" + args[1] + "'";
            }
        }
        log.debug((Object)("toIsoDate() attempting to parse \"" + args[0] + "\""));
        Date d = Time.parseDate((String)args[0]);
        if (d == null) {
            return "";
        }
        return Time.toIsoDate((long)d.getTime());
    }

    public static String date(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return DateTimeFunctions.toIsoDate(fe, wi, args);
    }

    public static String tadd(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return DateTimeFunctions.timeAdd(fe, wi, args);
    }

    public static String timeAdd(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length < 2) {
            throw new IllegalArgumentException("timeAdd() awaits 2 args.");
        }
        String sDate = args[0];
        String sDuration = args[1];
        int dmod = 1;
        if (sDuration.startsWith("-")) {
            sDuration = sDuration.substring(1);
            dmod = -1;
        }
        long date = 0L;
        try {
            date = Time.fromIsoDate((String)sDate);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Failed to parse date '" + sDate + "'");
        }
        long duration = (long)dmod * Time.parseTimeString((String)sDuration);
        return Time.toIsoDate((long)(date + duration));
    }

    public static String ststamp(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return ts_shortSdf.format(new Date());
    }

    public static String ltstamp(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return ts_longSdf.format(new Date());
    }

    public static String timestamp(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return DateTimeFunctions.vltstamp(fe, wi, args);
    }

    public static String vltstamp(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        return ts_veryLongSdf.format(new Date());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

