/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.functions;

import openwfe.org.engine.expressions.FlowExpression;
import openwfe.org.engine.workitem.InFlowWorkItem;
import org.apache.log4j.Logger;

public abstract class NumericFunctions {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$functions$NumericFunctions == null ? (class$openwfe$org$engine$impl$functions$NumericFunctions = NumericFunctions.class$("openwfe.org.engine.impl.functions.NumericFunctions")) : class$openwfe$org$engine$impl$functions$NumericFunctions).getName());
    static /* synthetic */ Class class$openwfe$org$engine$impl$functions$NumericFunctions;

    public static String add(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args == null) {
            return "0";
        }
        float result = 0.0f;
        for (int i = 0; i < args.length; ++i) {
            try {
                result += Float.parseFloat(args[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return "" + result;
    }

    public static String mod(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args.length < 2) {
            return "1.0";
        }
        try {
            return "" + Float.parseFloat(args[0]) % Float.parseFloat(args[1]);
        }
        catch (NumberFormatException nfe) {
            log.debug((Object)"mod() failure", (Throwable)nfe);
            return "1.0";
        }
    }

    public static String mul(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        if (args == null) {
            return "1";
        }
        float result = 1.0f;
        for (int i = 0; i < args.length; ++i) {
            try {
                result *= Float.parseFloat(args[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return "" + result;
    }

    public static String toint(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        try {
            return "" + (int)Double.parseDouble(args[0]);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static String isnumeric(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        try {
            Double.parseDouble(args[0]);
            return "true";
        }
        catch (Throwable throwable) {
            return "false";
        }
    }

    public static String round(FlowExpression fe, InFlowWorkItem wi, String[] args) {
        try {
            return "" + Math.round(Double.parseDouble(args[0]));
        }
        catch (Throwable t) {
            return "round failure : " + t;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

