/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.history;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.history.HistoryException;
import openwfe.org.engine.history.HistoryIterator;
import openwfe.org.engine.impl.history.AbstractHistory;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.sql.SqlUtils;
import openwfe.org.sql.ds.OwfeDataSource;
import org.apache.log4j.Logger;

public class SqlHistory
extends AbstractHistory {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$history$SqlHistory == null ? (class$openwfe$org$engine$impl$history$SqlHistory = SqlHistory.class$("openwfe.org.engine.impl.history.SqlHistory")) : class$openwfe$org$engine$impl$history$SqlHistory).getName());
    public static final String P_TABLE_NAME = "tableName";
    protected static final String COLUMNS = "date_, engineid, wfdname, wfdrevision, wfdid, expression, eventcode, participantname, message";
    private OwfeDataSource dataSource = null;
    private String tableName = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$history$SqlHistory;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.dataSource = SqlUtils.lookupDataSource((ApplicationContext)context, (Map)serviceParams);
        log.info((Object)"dataSource set");
        this.tableName = MapUtils.getAsString((Map)serviceParams, (String)P_TABLE_NAME, (String)"owfehistory");
        log.info((Object)("using tableName '" + this.tableName + "'"));
    }

    protected String getInsertString() {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(this.tableName);
        sb.append(" (");
        sb.append(COLUMNS);
        sb.append(" )");
        sb.append(" VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        return sb.toString();
    }

    public void log(final FlowExpressionId fei, final WorkItem wi, final String eventCode, final String participantName, final String message) {
        new Thread(){

            public void run() {
                SqlHistory.this.doLog(fei, wi, eventCode, participantName, message);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLog(FlowExpressionId fei, WorkItem wi, String eventCode, String participantName, String message) {
        PreparedStatement pst = null;
        try {
            pst = this.getDataSource().getConnection().prepareStatement(this.getInsertString());
            int i = 1;
            pst.setString(i++, new Timestamp(System.currentTimeMillis()).toString());
            pst.setString(i++, fei.getEngineId());
            pst.setString(i++, fei.getWorkflowDefinitionName());
            pst.setString(i++, fei.getWorkflowDefinitionRevision());
            pst.setString(i++, fei.getWorkflowInstanceId());
            pst.setString(i++, fei.getExpressionName() + " " + fei.getExpressionId());
            pst.setString(i++, eventCode);
            if (participantName == null) {
                pst.setString(i++, "");
            } else {
                pst.setString(i++, participantName);
            }
            pst.setString(i++, message);
            pst.executeUpdate();
        }
        catch (SQLException se) {
            try {
                log.warn((Object)"Failed to log to history", (Throwable)se);
                this.getDataSource().logSQLException("log", log, se);
            }
            catch (Throwable throwable) {
                SqlUtils.closeStatement(pst);
                this.getDataSource().releaseConnection();
                throw throwable;
            }
            SqlUtils.closeStatement((Statement)pst);
            this.getDataSource().releaseConnection();
        }
        SqlUtils.closeStatement((Statement)pst);
        this.getDataSource().releaseConnection();
    }

    public HistoryIterator browse(String workflowName, String workflowRevision, long workflowInstanceId, long dateFrom, long dateto) throws HistoryException {
        throw new HistoryException("Not yet implemented.");
    }

    public String getTableName() {
        return this.tableName;
    }

    protected OwfeDataSource getDataSource() {
        return this.dataSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

