/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.launch;

import java.util.HashMap;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.expressions.map.XmlExpressionMap;
import openwfe.org.engine.impl.launch.SimpleXmlLauncher;
import openwfe.org.engine.launch.Launcher;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class XmlWorkflowDefinitionValidator {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator == null ? (class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator = XmlWorkflowDefinitionValidator.class$("openwfe.org.engine.impl.launch.XmlWorkflowDefinitionValidator")) : class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator).getName());
    static /* synthetic */ Class class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator;

    private static ApplicationContext prepareContext(String expressionMapPath) throws ServiceException {
        ApplicationContext context = new ApplicationContext();
        XmlExpressionMap em = new XmlExpressionMap();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("expressionMapFile", expressionMapPath);
        em.init("expressionMap", context, params);
        SimpleXmlLauncher launcher = new SimpleXmlLauncher();
        params = new HashMap();
        launcher.init("launcher", context, params);
        context.put("expressionMap", (Object)em);
        context.put("launcher", (Object)launcher);
        return context;
    }

    private static void printRealUsage() {
        System.out.println("\nUSAGE :\n");
        System.out.println("  java -cp XXX " + (class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator == null ? (class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator = XmlWorkflowDefinitionValidator.class$("openwfe.org.engine.impl.launch.XmlWorkflowDefinitionValidator")) : class$openwfe$org$engine$impl$launch$XmlWorkflowDefinitionValidator).getName() + " {command_alias} {debug-level} {show-details} {path_to_expression-map} {flowDefinitionURL}\n");
    }

    private static void printUsage(String command) {
        System.out.println("\nUSAGE :\n");
        System.out.println("  " + command + " {flowDefinitionURL} [schema-validation]\n");
        System.out.println("  This command will complain if the given URL points to an invalid");
        System.out.println("  flow definition.");
        System.out.println("  If [schema-validation] is present and set to 'true', XSD schema validation");
        System.out.println("  will occur.\n");
    }

    private static void printCauses(boolean showDetails, Throwable t) {
        System.out.println("  ! " + t.getClass().getName() + " :");
        System.out.println("    " + t.getMessage());
        if (showDetails) {
            System.out.println();
            t.printStackTrace();
            System.out.println();
        }
        if (t.getCause() != null) {
            XmlWorkflowDefinitionValidator.printCauses(showDetails, t.getCause());
        }
    }

    public static void main(String[] args) throws Exception {
        String sVal;
        if (args.length < 4) {
            XmlWorkflowDefinitionValidator.printRealUsage();
            return;
        }
        if (args.length < 5) {
            XmlWorkflowDefinitionValidator.printUsage(args[0]);
            return;
        }
        BasicConfigurator.configure();
        log.getRootLogger().setLevel(Level.toLevel((String)args[1], (Level)Level.INFO));
        boolean showDetails = args[2].equals("true");
        System.out.println("\n       --  OpenWFE 1.7.0  --");
        System.out.println("\n       --- preparing services for validation ---");
        ApplicationContext context = XmlWorkflowDefinitionValidator.prepareContext(args[3]);
        Launcher launcher = Definitions.getLauncher(context);
        if (args.length >= 6 && (sVal = args[5].toLowerCase()) != null) {
            System.setProperty("openwfe.org.engine.launcher.validate", sVal);
        }
        System.out.println("\n       - XSD validation set to " + SimpleXmlLauncher.shouldValidate() + " -");
        System.out.println("\n       --- initiating validation ---");
        try {
            launcher.loadProcessDefinition(args[4]);
        }
        catch (Throwable t) {
            System.out.println("\n       !! " + args[4] + " is NOT valid !!\n");
            XmlWorkflowDefinitionValidator.printCauses(showDetails, t);
            System.out.println();
            System.exit(1);
            return;
        }
        System.out.println("\n       == " + args[4] + " is valid ==\n");
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

