/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.listen;

import java.util.Map;
import java.util.TimerTask;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import openwfe.org.Application;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.engine.listen.WorkItemListener;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.mail.MailUtils;
import org.apache.log4j.Logger;

public class MailListener
extends WorkItemListener {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$listen$MailListener == null ? (class$openwfe$org$engine$impl$listen$MailListener = MailListener.class$("openwfe.org.engine.impl.listen.MailListener")) : class$openwfe$org$engine$impl$listen$MailListener).getName());
    public static final String P_ACCOUNT_URL = "accountUrl";
    public static final String P_FOLDER = "folder";
    public static final String P_FREQUENCY = "frequency";
    private static final String DEFAULT_FREQUENCY = "30s";
    private URLName account = null;
    private String folder = null;
    private TimerTask pollTask = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$listen$MailListener;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        String sAccount = MapUtils.getMandatoryString((Map)serviceParams, (String)P_ACCOUNT_URL);
        this.account = new URLName(sAccount);
        this.folder = MapUtils.getAsString((Map)serviceParams, (String)P_FOLDER, (String)"INBOX");
        if (sAccount.startsWith("pop")) {
            this.folder = "INBOX";
        }
        long frequency = MapUtils.getAsTime((Map)serviceParams, (String)P_FREQUENCY, (String)DEFAULT_FREQUENCY);
        this.pollTask = new TimerTask(){

            public void run() {
                MailListener.this.poll();
            }
        };
        Application.getTimer().schedule(this.pollTask, 10L, frequency);
    }

    public void stop() throws ServiceException {
        super.stop();
        this.pollTask.cancel();
        log.info((Object)("'" + this.getName() + "' Stopped."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected synchronized void poll() {
        block17: {
            Session mailSession = null;
            Folder mailFolder = null;
            Store mailStore = null;
            mailSession = MailUtils.getMailSession((Map)this.getParams());
            mailStore = mailSession.getStore(this.account);
            mailStore.connect();
            mailFolder = mailStore.getFolder(this.folder);
            mailFolder.open(2);
            Message[] messages = mailFolder.getMessages();
            log.debug((Object)("poll() examining " + messages.length + " messages"));
            for (int i = 0; i < messages.length; ++i) {
                Message m = messages[i];
                log.debug((Object)("poll() message subject is >" + m.getSubject() + "<"));
                try {
                    this.handleMessage(m);
                    m.setFlag(Flags.Flag.DELETED, true);
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to handle message >" + m.getSubject() + "<. Skipped."));
                }
            }
            Object var9_9 = null;
            try {
                mailFolder.close(true);
            }
            catch (Throwable t2) {
                // empty catch block
            }
            try {
                mailStore.close();
            }
            catch (Throwable t2) {}
            break block17;
            {
                catch (Throwable t) {
                    log.warn((Object)"poll() failure", t);
                    Object var9_10 = null;
                    try {
                        mailFolder.close(true);
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    try {
                        mailStore.close();
                    }
                    catch (Throwable t2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    mailFolder.close(true);
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                try {
                    mailStore.close();
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void handleMessage(Message m) throws Exception {
        String s = m.getContent().toString();
        int n = s.indexOf("\n");
        String coderName = s.substring(0, n).trim();
        String sWorkItem = s.substring(n + 1).trim();
        WorkItem wi = this.getCoder(coderName).decode(sWorkItem, this.getContext(), this.getParams());
        this.getConsumer().use(wi);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

