/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.participants;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder;
import openwfe.org.engine.participants.LeafParticipant;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import org.apache.log4j.Logger;

public class FileArchivingParticipant
extends LeafParticipant {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$participants$FileArchivingParticipant == null ? (class$openwfe$org$engine$impl$participants$FileArchivingParticipant = FileArchivingParticipant.class$("openwfe.org.engine.impl.participants.FileArchivingParticipant")) : class$openwfe$org$engine$impl$participants$FileArchivingParticipant).getName());
    public static final String P_ARCHIVAL_DIR = "archivalDir";
    private String archivalDir = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$participants$FileArchivingParticipant;

    public void init(String regex, Map params) {
        super.init(regex, params);
        this.archivalDir = (String)params.get(P_ARCHIVAL_DIR);
        if (this.archivalDir == null) {
            this.archivalDir = "archive";
        }
        if (!this.archivalDir.endsWith(File.separator)) {
            this.archivalDir = this.archivalDir + File.separator;
        }
        log.info((Object)("init() archivalDir is '" + this.archivalDir + "'"));
    }

    public Object dispatch(ApplicationContext context, WorkItem wi) throws DispatchingException {
        this.save(context, wi);
        this.reply(context, wi);
        return null;
    }

    public String getArchivalDir() {
        return this.archivalDir;
    }

    protected void save(ApplicationContext context, WorkItem wi) throws DispatchingException {
        XmlWorkItemCoder coder = Definitions.getXmlCoder(context);
        String fileName = this.determineFileName(((InFlowWorkItem)wi).getId());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            byte[] bWi = coder.doEncode(wi);
            fos.write(bWi);
            fos.flush();
            log.debug((Object)("save() archived wi to '" + fileName + "'"));
        }
        catch (Throwable t) {
            throw new DispatchingException("failed to archive (save) workitem to '" + fileName + "'", t);
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable t) {}
        }
    }

    protected String determineFileName(FlowExpressionId fei) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getArchivalDir());
        sb.append("arc_").append(fei.getWorkflowDefinitionName()).append("_").append(fei.getWorkflowDefinitionRevision()).append("__").append(fei.getWorkflowInstanceId()).append("_e").append(fei.getExpressionId()).append(".xml");
        return sb.toString();
    }

    protected void reply(ApplicationContext context, WorkItem wi) throws DispatchingException {
        InFlowWorkItem ifwi = (InFlowWorkItem)wi;
        try {
            Definitions.getExpressionPool(context).reply(ifwi.getId(), ifwi);
        }
        catch (Throwable t) {
            throw new DispatchingException("failed to feed back workitem to engine", t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

