/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.participants;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.engine.participants.AbstractParticipantMap;
import openwfe.org.engine.participants.LeafParticipant;
import openwfe.org.ldap.LdapService;
import org.apache.log4j.Logger;

public class LdapParticipantMap
extends AbstractParticipantMap {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$participants$LdapParticipantMap == null ? (class$openwfe$org$engine$impl$participants$LdapParticipantMap = LdapParticipantMap.class$("openwfe.org.engine.impl.participants.LdapParticipantMap")) : class$openwfe$org$engine$impl$participants$LdapParticipantMap).getName());
    private LdapService m_ldapService;
    static /* synthetic */ Class class$openwfe$org$engine$impl$participants$LdapParticipantMap;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        try {
            this.m_ldapService = (LdapService)this.getContext().get("ldapService");
            if (this.m_ldapService == null) {
                throw new ServiceException("LDAP Service not found.");
            }
            this.buildMap();
        }
        catch (NamingException e) {
            throw new ServiceException("LDAP configure error", (Throwable)e);
        }
    }

    protected void refreshMap() throws ServiceException {
    }

    protected void buildMap() throws NamingException {
        LeafParticipant p = new LeafParticipant();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("host", "127.0.0.1");
        params.put("port", "7007");
        params.put("dispatcherClass", "openwfe.org.engine.impl.dispatch.SocketDispatcher");
        params.put("workItemCoder", "xmlCoder");
        p.init("mainEngine", params);
        this.add(p);
        this.addGroups();
        this.addUsers();
    }

    private void addGroups() throws NamingException {
        String[] groups = this.m_ldapService.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            LeafParticipant p = new LeafParticipant();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("host", "127.0.0.1");
            params.put("port", "7008");
            params.put("dispatcherClass", "openwfe.org.engine.impl.dispatch.SocketDispatcher");
            p.init(groups[i], params);
            if (log.isDebugEnabled()) {
                log.debug((Object)("LDAP adding " + p.getRegex()));
            }
            this.add(p);
        }
    }

    private void addUsers() throws NamingException {
        String[] users = this.m_ldapService.getUsers();
        for (int i = 0; i < users.length; ++i) {
            LeafParticipant p = new LeafParticipant();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("host", "127.0.0.1");
            params.put("port", "7008");
            params.put("dispatcherClass", "openwfe.org.engine.impl.dispatch.SocketDispatcher");
            p.init(users[i], params);
            if (log.isDebugEnabled()) {
                log.debug((Object)("LDAP adding " + p.getRegex()));
            }
            this.add(p);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

