/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.participants;

import java.io.BufferedWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.Utils;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.participants.LeafParticipant;
import openwfe.org.engine.workitem.AttributeUtils;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.mail.MailUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class MailNotifiedParticipant
extends LeafParticipant {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$participants$MailNotifiedParticipant == null ? (class$openwfe$org$engine$impl$participants$MailNotifiedParticipant = MailNotifiedParticipant.class$("openwfe.org.engine.impl.participants.MailNotifiedParticipant")) : class$openwfe$org$engine$impl$participants$MailNotifiedParticipant).getName());
    public static final String P_TEMPLATE = "template";
    private static final String DEFAULT_TEMPLATE = "This is a notification :\n you received an OpenWFE workitem ('${__subject__}')";
    public static final String P_RECIPIENT_FIELD = "recipient-field";
    public static final String DEFAULT_RECIPIENT_FIELD = "__recipient__";
    public static final String P_MAIL_FROM = "mail-from";
    public static final String P_MAIL_ENCODING = "mail-encoding";
    private static final String DEFAULT_MAIL_ENCODING = "iso-8859-1";
    public static final String C_WORKITEM = "workitem";
    private String recipientField = null;
    private String mailFrom = null;
    private String mailEncoding = null;
    private String templateFileName = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$participants$MailNotifiedParticipant;

    public void init(String regex, Map params) {
        super.init(regex, params);
        this.recipientField = MapUtils.getAsString((Map)params, (String)P_RECIPIENT_FIELD, (String)DEFAULT_RECIPIENT_FIELD);
        this.mailFrom = MapUtils.getAsString((Map)params, (String)P_MAIL_FROM);
        this.mailEncoding = MapUtils.getAsString((Map)params, (String)P_MAIL_ENCODING);
        this.templateFileName = MapUtils.getAsString((Map)params, (String)P_TEMPLATE);
    }

    public Object dispatch(ApplicationContext context, WorkItem wi) throws DispatchingException {
        Object result = super.dispatch(context, wi);
        try {
            this.sendNotificationMail((InFlowWorkItem)wi);
            log.debug((Object)"apply() notification email sucessfully sent.");
        }
        catch (Exception e) {
            log.warn((Object)"apply() failed to send notification mail", (Throwable)e);
        }
        return result;
    }

    private String[] splitSubjectAndBody(String in) {
        int i = (in = in.trim()).indexOf("\n");
        if (i < 0) {
            return new String[]{"", in};
        }
        return new String[]{in.substring(0, i), in.substring(i + 1)};
    }

    private void sendNotificationMail(InFlowWorkItem wi) throws Exception {
        Session mailSession = MailUtils.getMailSession((Map)this.getParams());
        MimeMessage message = new MimeMessage(mailSession);
        message.setSentDate(new Date());
        MailUtils.setMailFrom((Message)message, (Map)this.getParams());
        VelocityContext context = new VelocityContext();
        Iterator it = wi.getAttributes().stringKeySet().iterator();
        while (it.hasNext()) {
            String k = (String)it.next();
            context.put(k, (Object)wi.getAttributes().get(k).toString());
        }
        context.put(C_WORKITEM, (Object)wi);
        List recipients = AttributeUtils.owfe2list(wi.getAttributes().get(new StringAttribute(this.recipientField)), ", *");
        it = recipients.iterator();
        while (it.hasNext()) {
            String recipient = (String)it.next();
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
        }
        Velocity.init();
        Template template = Velocity.getTemplate((String)this.templateFileName);
        StringWriter writer = new StringWriter();
        BufferedWriter bw = new BufferedWriter(writer);
        template.merge((Context)context, (Writer)bw);
        bw.flush();
        bw.close();
        String[] ss = this.splitSubjectAndBody(writer.toString());
        String encoding = Utils.getEncoding();
        if (this.mailEncoding != null) {
            encoding = this.mailEncoding;
        }
        message.setFrom((Address)new InternetAddress(this.mailFrom));
        message.setSubject(ss[0]);
        message.setText(ss[1], encoding);
        mailSession.getTransport("smtp");
        Transport.send((Message)message);
        log.debug((Object)"sendNotificationMail() done.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

