/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.workitem.xml;

import java.io.InputStream;
import openwfe.org.OpenWfeException;
import openwfe.org.engine.impl.workitem.xml.WicUtils;
import openwfe.org.engine.listen.reply.FatalReply;
import openwfe.org.engine.listen.reply.ListenerReply;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.listen.reply.OkReply;
import openwfe.org.engine.listen.reply.WarningReply;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class ReplyCoder
implements ListenerReplyCoder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$workitem$xml$ReplyCoder == null ? (class$openwfe$org$engine$impl$workitem$xml$ReplyCoder = ReplyCoder.class$("openwfe.org.engine.impl.workitem.xml.ReplyCoder")) : class$openwfe$org$engine$impl$workitem$xml$ReplyCoder).getName());
    public static final String OK_REPLY = "ok-reply";
    public static final String WARNING_REPLY = "warning-reply";
    public static final String FATAL_REPLY = "fatal-reply";
    public static final String CANCELLED_REPLY = "cancelled-reply";
    static /* synthetic */ Class class$openwfe$org$engine$impl$workitem$xml$ReplyCoder;

    public ListenerReply decode(Object o) throws CodingException {
        Element elt = null;
        if (o instanceof Element) {
            elt = (Element)o;
        } else if (o instanceof InputStream) {
            log.debug((Object)("decode() InputStream of class " + o.getClass().getName()));
            elt = WicUtils.fetchElementFromStream((InputStream)o);
        } else {
            throw new CodingException("Cannot decode instances of class '" + o.getClass().getName() + "'");
        }
        if (elt.getName().equals(OK_REPLY)) {
            String consumerResult = elt.getAttributeValue("consumer-result");
            return new OkReply(consumerResult);
        }
        String message = elt.getAttributeValue("message");
        String exceptionMessage = elt.getAttributeValue("exceptionMessage");
        String exceptionStackTrace = elt.getAttributeValue("exceptionStackTrace");
        WarningReply reply = null;
        if (elt.getName().equals(WARNING_REPLY)) {
            reply = new WarningReply();
        } else if (elt.getName().equals(FATAL_REPLY)) {
            reply = new FatalReply();
        } else {
            throw new CodingException("cannot decode replies named '" + elt.getName() + "'");
        }
        reply.setMessage(message);
        reply.setExceptionMessage(exceptionMessage);
        reply.setExceptionStackTrace(exceptionStackTrace);
        return reply;
    }

    public byte[] encode(ListenerReply reply) throws CodingException {
        Object elt = null;
        try {
            if (reply instanceof OkReply) {
                return XmlUtils.toByteArray((Element)this.encode((OkReply)reply));
            }
            if (reply instanceof FatalReply) {
                return XmlUtils.toByteArray((Element)this.encode((FatalReply)reply));
            }
            if (reply instanceof WarningReply) {
                return XmlUtils.toByteArray((Element)this.encode((WarningReply)reply));
            }
        }
        catch (OpenWfeException owe) {
            throw new CodingException("reply encoding failed", owe);
        }
        throw new CodingException("Not able to encode replies of class '" + reply.getClass().getName() + "'");
    }

    protected Element encode(OkReply reply) {
        Element elt = new Element(OK_REPLY);
        if (reply.getConsumerResult() != null) {
            elt.setAttribute("consumer-result", reply.getConsumerResult().toString());
        }
        return elt;
    }

    protected Element encode(WarningReply reply) {
        Element elt = new Element(WARNING_REPLY);
        if (reply.getMessage() != null) {
            elt.setAttribute("message", reply.getMessage());
        }
        if (reply.getExceptionMessage() != null) {
            elt.setAttribute("exceptionMessage", reply.getExceptionMessage());
        }
        if (reply.getExceptionStackTrace() != null) {
            elt.addContent(reply.getExceptionStackTrace());
        }
        return elt;
    }

    protected Element encode(FatalReply reply) {
        Element eReply = this.encode((WarningReply)reply);
        eReply.setName(FATAL_REPLY);
        return eReply;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

