/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.impl.workitem.xml;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.OpenWfeException;
import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.impl.workitem.AbstractWorkItemCoder;
import openwfe.org.engine.impl.workitem.xml.AbstractXmlAttributeCoder;
import openwfe.org.engine.impl.workitem.xml.WicUtils;
import openwfe.org.engine.listen.reply.ListenerReplyCoder;
import openwfe.org.engine.participants.Filter;
import openwfe.org.engine.participants.FilterEntry;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.AttributeCoder;
import openwfe.org.engine.workitem.CancelItem;
import openwfe.org.engine.workitem.CodingException;
import openwfe.org.engine.workitem.HistoryItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.engine.workitem.WorkItem;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class XmlWorkItemCoder
extends AbstractWorkItemCoder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$impl$workitem$xml$XmlWorkItemCoder == null ? (class$openwfe$org$engine$impl$workitem$xml$XmlWorkItemCoder = XmlWorkItemCoder.class$("openwfe.org.engine.impl.workitem.xml.XmlWorkItemCoder")) : class$openwfe$org$engine$impl$workitem$xml$XmlWorkItemCoder).getName());
    public static final String WORKFLOW_DEFINITION_URL = "workflow-definition-url";
    public static final String PROCESS_DEFINITION_URL = "process-definition-url";
    public static final String WORKFLOW_DEFINITION_NAME = "workflow-definition-name";
    public static final String WORKFLOW_DEFINITION_REVISION = "workflow-definition-revision";
    public static final String WORKFLOW_INSTANCE_ID = "workflow-instance-id";
    public static final String LAST_MODIFIED = "last-modified";
    public static final String SIGNER = "signer";
    public static final String SIGNATURE = "signature";
    public static final String ATTRIBUTES = "attributes";
    public static final String PARTICIPANT_NAME = "participant-name";
    public static final String DISPATCH_TIME = "dispatch-time";
    public static final String LAST_EXPRESSION_ID = "last-expression-id";
    public static final String LAUNCHITEM = "launchitem";
    public static final String CANCELITEM = "cancelitem";
    public static final String WORKITEM = "workitem";
    public static final String DESCRIPTION_MAP = "description-map";
    public static final String FLOW_EXPRESSION_ID = "flow-expression-id";
    public static final String OWFE_VERSION = "owfe-version";
    public static final String ENGINE_ID = "engine-id";
    public static final String INITIAL_ENGINE_ID = "initial-engine-id";
    public static final String EXPRESSION_NAME = "expression-name";
    public static final String EXPRESSION_ID = "expression-id";
    public static final String OPEN_FILTER = "open-filter";
    public static final String CLOSED_FILTER = "closed-filter";
    public static final String REGEX = "regex";
    public static final String PERMISSIONS = "permissions";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String ADD_ALLOWED = "add-allowed";
    public static final String REMOVE_ALLOWED = "remove-allowed";
    public static final String READ_WRITE = "read-write";
    public static final String READ_ONLY = "read-only";
    public static final String HIDE = "hide";
    public static final String FIELD = "field";
    public static final String HISTORY = "history";
    public static final String HISTORY_ITEM = "history-item";
    public static final String DATE = "date";
    public static final String AUTHOR = "author";
    public static final String HOST = "host";
    public static final int BUFFER_SIZE = 131072;
    public static final String SMAP = "smap";
    private ApplicationContext applicationContext = null;
    private Map perRepresentationMap = null;
    static /* synthetic */ Class class$openwfe$org$engine$impl$workitem$xml$XmlWorkItemCoder;

    public void init(String name, List attributeCoders, ListenerReplyCoder replyCoder) {
        super.init(name, attributeCoders, replyCoder);
        this.perRepresentationMap = new HashMap(attributeCoders.size());
        Iterator it = attributeCoders.iterator();
        while (it.hasNext()) {
            AbstractXmlAttributeCoder coder = (AbstractXmlAttributeCoder)it.next();
            this.perRepresentationMap.put(coder.getRepresentationName(), coder);
            log.debug((Object)("init() put '" + coder.getClass().getName() + "' for '" + coder.getRepresentationName() + "'"));
        }
    }

    public AbstractXmlAttributeCoder getAttributeCoder(String representationName) {
        return (AbstractXmlAttributeCoder)this.perRepresentationMap.get(representationName);
    }

    public byte[] doEncode(WorkItem wi) throws CodingException {
        return (byte[])this.encode(wi, null, null);
    }

    public Object encode(WorkItem wi, ApplicationContext context, Map serviceParams) throws CodingException {
        log.debug((Object)("encode() wi of class " + wi.getClass().getName()));
        this.applicationContext = context;
        Element eWi = this.encodeAsXml(wi);
        try {
            byte[] o = XmlUtils.toByteArray((Element)eWi);
            return o;
        }
        catch (OpenWfeException owe) {
            throw new CodingException("Failed to turn encoded workitem into a byte array", owe);
        }
    }

    protected Element encodeSuper(WorkItem wi) throws CodingException {
        Element elt = new Element(WORKITEM);
        if (wi.getLastModified() != null) {
            WicUtils.setAttribute(elt, LAST_MODIFIED, wi.getLastModified());
        }
        Element as = new Element(ATTRIBUTES);
        Element smap = this.encodeAttribute(wi.getAttributes());
        if (smap != null) {
            as.addContent((Content)smap);
        }
        elt.addContent((Content)as);
        return elt;
    }

    public Element encodeAsXml(WorkItem wi) throws CodingException {
        if (wi instanceof InFlowWorkItem) {
            return this.encodeAsXml((InFlowWorkItem)wi);
        }
        if (wi instanceof LaunchItem) {
            return this.encodeAsXml((LaunchItem)wi);
        }
        return this.encodeCancelItemAsXml((CancelItem)wi);
    }

    protected Element encodeCancelItemAsXml(CancelItem ci) throws CodingException {
        log.debug((Object)("encodeCancelItemAsXml() " + ci.getId()));
        Element elt = this.encodeSuper(ci);
        elt.setName(CANCELITEM);
        Element ei = new Element(LAST_EXPRESSION_ID);
        ei.addContent((Content)this.encode(ci.getId()));
        elt.addContent((Content)ei);
        WicUtils.setAttribute(elt, PARTICIPANT_NAME, ci.getParticipantName());
        return elt;
    }

    protected Element encodeAsXml(InFlowWorkItem wi) throws CodingException {
        Element elt = this.encodeSuper(wi);
        WicUtils.setAttribute(elt, PARTICIPANT_NAME, wi.getParticipantName());
        WicUtils.setAttribute(elt, DISPATCH_TIME, wi.getDispatchTime());
        if (wi.getLastExpressionId() != null) {
            Element lei = new Element(LAST_EXPRESSION_ID);
            lei.addContent((Content)this.encode(wi.getLastExpressionId()));
            elt.addContent((Content)lei);
        }
        if (wi.getFilter() != null) {
            elt.addContent((Content)this.encode(wi.getFilter()));
        }
        Element his = new Element(HISTORY);
        if (wi.getHistory() != null) {
            Iterator it = wi.getHistory().iterator();
            while (it.hasNext()) {
                his.addContent((Content)this.encodeAsXml((HistoryItem)it.next()));
            }
        }
        elt.addContent((Content)his);
        return elt;
    }

    public Element encodeAsXml(HistoryItem hi) {
        Element elt = new Element(HISTORY_ITEM);
        elt.setAttribute(DATE, "" + hi.getDate());
        elt.setAttribute(AUTHOR, "" + hi.getAuthor());
        elt.setAttribute(HOST, "" + hi.getHost());
        elt.setAttribute(WORKFLOW_DEFINITION_NAME, "" + hi.getWorkflowDefinitionName());
        elt.setAttribute(WORKFLOW_DEFINITION_REVISION, "" + hi.getWorkflowDefinitionRevision());
        elt.setAttribute(WORKFLOW_INSTANCE_ID, "" + hi.getWorkflowInstanceId());
        elt.setAttribute(EXPRESSION_ID, "" + hi.getExpressionId());
        elt.setText(hi.getText());
        return elt;
    }

    protected Element encodeAsXml(LaunchItem li) throws CodingException {
        Element elt = this.encodeSuper(li);
        elt.setName(LAUNCHITEM);
        elt.setAttribute(PROCESS_DEFINITION_URL, li.getWorkflowDefinitionUrl());
        Element dm = new Element(DESCRIPTION_MAP);
        if (li.getDescriptionMap() != null) {
            dm.addContent((Content)this.encodeAttribute(li.getDescriptionMap()));
        }
        elt.addContent((Content)dm);
        return elt;
    }

    public Element encodeAttribute(Attribute a) throws CodingException {
        if (a == null) {
            return null;
        }
        AttributeCoder coder = (AttributeCoder)this.getPerClassMap().get(a.getClass().getName());
        if (coder == null) {
            Element elt = new Element("error");
            Comment cmt = new Comment("No coder for Attribute of class '" + a.getClass().getName() + "'");
            elt.addContent((Content)cmt);
            return elt;
        }
        return (Element)coder.encode(a, null);
    }

    public Element encode(FlowExpressionId fei) {
        Element elt = new Element(FLOW_EXPRESSION_ID);
        WicUtils.setAttribute(elt, OWFE_VERSION, fei.getOwfeVersion());
        WicUtils.setAttribute(elt, ENGINE_ID, fei.getEngineId());
        WicUtils.setAttribute(elt, INITIAL_ENGINE_ID, fei.getInitialEngineId());
        WicUtils.setAttribute(elt, WORKFLOW_DEFINITION_URL, fei.getWorkflowDefinitionUrl());
        WicUtils.setAttribute(elt, WORKFLOW_DEFINITION_NAME, fei.getWorkflowDefinitionName());
        WicUtils.setAttribute(elt, WORKFLOW_DEFINITION_REVISION, fei.getWorkflowDefinitionRevision());
        WicUtils.setAttribute(elt, WORKFLOW_INSTANCE_ID, "" + fei.getWorkflowInstanceId());
        WicUtils.setAttribute(elt, EXPRESSION_NAME, fei.getExpressionName());
        WicUtils.setAttribute(elt, EXPRESSION_ID, "" + fei.getExpressionId());
        return elt;
    }

    public Element encode(Filter f) {
        Element elt = null;
        elt = f.getType() == 0 ? new Element(OPEN_FILTER) : new Element(CLOSED_FILTER);
        WicUtils.setAttribute(elt, NAME, f.getName());
        WicUtils.setAttribute(elt, ADD_ALLOWED, "" + f.isAddAllowed());
        WicUtils.setAttribute(elt, REMOVE_ALLOWED, "" + f.isRemoveAllowed());
        this.encodeEntryList(elt, f);
        return elt;
    }

    protected void encodeEntryList(Element result, Filter f) {
        if (f.getEntries() == null || f.getEntries().size() < 1) {
            return;
        }
        Iterator it = f.getEntries().iterator();
        while (it.hasNext()) {
            FilterEntry entry = (FilterEntry)it.next();
            if (entry.getPermissions().trim().equals("")) continue;
            Element elt = new Element(FIELD);
            elt.setAttribute(REGEX, entry.getFieldRegex());
            elt.setAttribute(PERMISSIONS, entry.getPermissions());
            result.addContent((Content)elt);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document fetchDocument(Object o) throws CodingException {
        Reader reader;
        InputStream stream;
        block20: {
            log.debug((Object)("fetchDocument() instance of " + o.getClass().getName()));
            stream = null;
            reader = null;
            try {
                if (o instanceof Reader) {
                    reader = (Reader)o;
                    break block20;
                }
                if (o instanceof File) {
                    reader = new FileReader((File)o);
                    break block20;
                }
                if (o instanceof String) {
                    reader = new StringReader((String)o);
                    break block20;
                }
                if (o instanceof InputStream) {
                    stream = (InputStream)o;
                    break block20;
                }
                if (o instanceof URL) {
                    stream = ((URL)o).openStream();
                    break block20;
                }
                if (o instanceof Document) {
                    return (Document)o;
                }
                if (!(o instanceof Element)) throw new CodingException("Cannot decode " + o.getClass().getName());
                return (Document)((Element)o).getParent();
            }
            catch (Throwable t) {
                throw new CodingException("Failed to decode workitem", t);
            }
        }
        if (stream != null) {
            log.debug((Object)"fetchDocument() using stream.");
        } else {
            log.debug((Object)"fetchDocument() using reader.");
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            try {
                doc = stream != null ? builder.build(stream) : builder.build(reader);
            }
            catch (Throwable t) {
                throw new CodingException("Failed to decode incoming workitem with SAX", t);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable t) {}
        if (stream != null) {
            stream.close();
        }
        if (reader == null) return doc;
        reader.close();
        return doc;
    }

    public WorkItem decode(Object o, ApplicationContext context, Map serviceParams) throws CodingException {
        log.debug((Object)"decode()");
        Document doc = this.fetchDocument(o);
        Element rootElt = doc.getRootElement();
        WorkItem wi = null;
        log.debug((Object)("decode() rootElt is >" + rootElt.getName() + "<"));
        if (rootElt.getName().equals(WORKITEM)) {
            wi = this.decodeInFlowWorkItem(rootElt);
        } else if (rootElt.getName().equals(LAUNCHITEM)) {
            wi = this.decodeLaunchItem(rootElt);
        } else if (rootElt.getName().equals(CANCELITEM)) {
            wi = this.decodeCancelItem(rootElt);
        } else {
            throw new CodingException("Cannot handle elements named '" + rootElt.getName() + "' as workitems");
        }
        this.decodeWorkItem(wi, rootElt);
        return wi;
    }

    public FlowExpressionId decodeFlowExpressionId(Element elt) {
        FlowExpressionId fei = new FlowExpressionId();
        fei.setOwfeVersion(elt.getAttributeValue(OWFE_VERSION));
        fei.setEngineId(elt.getAttributeValue(ENGINE_ID));
        fei.setInitialEngineId(elt.getAttributeValue(INITIAL_ENGINE_ID));
        fei.setWorkflowDefinitionUrl(elt.getAttributeValue(WORKFLOW_DEFINITION_URL));
        fei.setWorkflowDefinitionName(elt.getAttributeValue(WORKFLOW_DEFINITION_NAME));
        fei.setWorkflowDefinitionRevision(elt.getAttributeValue(WORKFLOW_DEFINITION_REVISION));
        fei.setExpressionName(elt.getAttributeValue(EXPRESSION_NAME));
        fei.setWorkflowInstanceId(elt.getAttributeValue(WORKFLOW_INSTANCE_ID));
        fei.setExpressionId(elt.getAttributeValue(EXPRESSION_ID));
        return fei;
    }

    protected void decodeWorkItem(WorkItem target, Element elt) throws CodingException {
        log.debug((Object)"decodeworkItem()");
        target.setLastModified(elt.getAttributeValue(LAST_MODIFIED));
        Element attElt = elt.getChild(ATTRIBUTES);
        if (attElt != null && (attElt = attElt.getChild(SMAP)) != null) {
            AbstractXmlAttributeCoder coder = this.getAttributeCoder(SMAP);
            target.setAttributes((StringMapAttribute)coder.decode(attElt, null));
        }
    }

    public Attribute decodeAttribute(Element elt) throws CodingException {
        AbstractXmlAttributeCoder coder = this.getAttributeCoder(elt.getName());
        if (coder == null) {
            throw new CodingException("No coder for '" + elt.getName() + "'");
        }
        return coder.decode(elt, null);
    }

    protected InFlowWorkItem decodeInFlowWorkItem(Element elt) throws CodingException {
        InFlowWorkItem wi = new InFlowWorkItem();
        Element leiElt = elt.getChild(LAST_EXPRESSION_ID);
        if (leiElt != null) {
            leiElt = leiElt.getChild(FLOW_EXPRESSION_ID);
            wi.setId(this.decodeFlowExpressionId(leiElt));
        }
        wi.setParticipantName(elt.getAttributeValue(PARTICIPANT_NAME));
        wi.setDispatchTime(elt.getAttributeValue(DISPATCH_TIME));
        wi.setFilter(this.decodeFilter(elt));
        wi.setHistory(this.decodeHistory(elt));
        return wi;
    }

    protected CancelItem decodeCancelItem(Element elt) throws CodingException {
        CancelItem ci = new CancelItem();
        Element eiElt = elt.getChild(LAST_EXPRESSION_ID);
        if (eiElt != null) {
            eiElt = eiElt.getChild(FLOW_EXPRESSION_ID);
            ci.setId(this.decodeFlowExpressionId(eiElt));
        }
        ci.setParticipantName(elt.getAttributeValue(PARTICIPANT_NAME));
        return ci;
    }

    protected List decodeHistory(Element elt) {
        ArrayList<HistoryItem> history = new ArrayList<HistoryItem>(7);
        Element hElt = elt.getChild(HISTORY);
        if (hElt == null) {
            return history;
        }
        Iterator it = hElt.getChildren(HISTORY_ITEM).iterator();
        while (it.hasNext()) {
            history.add(this.decodeHistoryItem((Element)it.next()));
        }
        return history;
    }

    protected HistoryItem decodeHistoryItem(Element elt) {
        HistoryItem item = new HistoryItem();
        item.setDate(elt.getAttributeValue(DATE));
        item.setAuthor(elt.getAttributeValue(AUTHOR));
        item.setHost(elt.getAttributeValue(HOST));
        item.setText(elt.getTextTrim());
        item.setWorkflowDefinitionName(elt.getAttributeValue(WORKFLOW_DEFINITION_NAME));
        item.setWorkflowDefinitionRevision(elt.getAttributeValue(WORKFLOW_DEFINITION_REVISION));
        try {
            item.setWorkflowInstanceId(elt.getAttributeValue(WORKFLOW_INSTANCE_ID));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        item.setExpressionId(elt.getAttributeValue(EXPRESSION_ID));
        return item;
    }

    protected Filter decodeFilter(Element elt) {
        Element filterElt = elt.getChild(CLOSED_FILTER);
        if (filterElt == null) {
            filterElt = elt.getChild(OPEN_FILTER);
        }
        if (filterElt == null) {
            return null;
        }
        Filter filter = new Filter();
        if (filterElt.getName().equals(OPEN_FILTER)) {
            filter.setType(0);
        } else {
            filter.setType(1);
        }
        filter.setName(filterElt.getAttributeValue(NAME));
        String s = filterElt.getAttributeValue(ADD_ALLOWED);
        filter.setAddAllowed(s != null && s.trim().toLowerCase().equals("true"));
        s = filterElt.getAttributeValue(REMOVE_ALLOWED);
        filter.setRemoveAllowed(s != null && s.trim().toLowerCase().equals("true"));
        filter.setEntries(this.decodeEntryList(filterElt));
        return filter;
    }

    protected List decodeEntryList(Element filterElt) {
        ArrayList<FilterEntry> result = new ArrayList<FilterEntry>();
        Iterator it = filterElt.getChildren(FIELD).iterator();
        while (it.hasNext()) {
            Element elt = (Element)it.next();
            String fieldRegex = elt.getAttributeValue(REGEX).trim();
            String permissions = elt.getAttributeValue(PERMISSIONS).trim();
            FilterEntry entry = new FilterEntry(fieldRegex, permissions);
            result.add(entry);
        }
        return result;
    }

    protected LaunchItem decodeLaunchItem(Element elt) throws CodingException {
        Element dmElt;
        LaunchItem li = new LaunchItem();
        li.setWorkflowDefinitionUrl(elt.getAttributeValue(WORKFLOW_DEFINITION_URL));
        if (li.getWorkflowDefinitionUrl() == null) {
            li.setWorkflowDefinitionUrl(elt.getAttributeValue(PROCESS_DEFINITION_URL));
        }
        if ((dmElt = elt.getChild(DESCRIPTION_MAP)) != null && dmElt.getChild(SMAP) != null) {
            dmElt = dmElt.getChild(SMAP);
            AbstractXmlAttributeCoder coder = this.getAttributeCoder(SMAP);
            StringMapAttribute smap = (StringMapAttribute)coder.decode(dmElt, null);
            li.setDescriptionMap(smap);
        }
        return li;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

