/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.participants;

import java.util.HashMap;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.engine.Definitions;
import openwfe.org.engine.dispatch.DispatchingException;
import openwfe.org.engine.dispatch.WorkItemDispatcher;
import openwfe.org.engine.history.History;
import openwfe.org.engine.participants.AbstractParticipant;
import openwfe.org.engine.workitem.InFlowItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.WorkItem;
import org.apache.log4j.Logger;

public class LeafParticipant
extends AbstractParticipant {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$participants$LeafParticipant == null ? (class$openwfe$org$engine$participants$LeafParticipant = LeafParticipant.class$("openwfe.org.engine.participants.LeafParticipant")) : class$openwfe$org$engine$participants$LeafParticipant).getName());
    public static final String P_DISPATCHER_CLASS = "dispatcherClass";
    private String dispatcherClassName = null;
    static /* synthetic */ Class class$openwfe$org$engine$participants$LeafParticipant;

    public void init(String regex, Map params) {
        super.init(regex, params);
        this.dispatcherClassName = MapUtils.getAsString((Map)params, (String)P_DISPATCHER_CLASS);
    }

    public String getDispatcherClassName() {
        return this.dispatcherClassName;
    }

    public void setDispatcherClassName(String s) {
        this.dispatcherClassName = s;
    }

    protected WorkItemDispatcher instantiateDispatcher(ApplicationContext context, WorkItem wi) throws DispatchingException {
        WorkItemDispatcher dispatcher = null;
        if (this.dispatcherClassName == null) {
            throw new DispatchingException("participant '" + this.getRegex() + "' is missing a " + "'dispatcherClass' parameter, " + "cannot dispatch workitems to it");
        }
        try {
            Class<?> dispatcherClass = Class.forName(this.dispatcherClassName);
            dispatcher = (WorkItemDispatcher)dispatcherClass.newInstance();
            HashMap<String, String> dispatcherParams = new HashMap<String, String>();
            dispatcherParams.putAll(this.getParams());
            dispatcherParams.put("__participant__", this.getRegex());
            dispatcher.init(this.getRegex() + ".dispatcher", context, dispatcherParams);
        }
        catch (Exception e) {
            throw new DispatchingException("Failed to instantiate dispatcher '" + this.dispatcherClassName + "' for participant '" + this.getRegex() + "'", e);
        }
        return dispatcher;
    }

    public Object dispatch(ApplicationContext context, WorkItem wi) throws DispatchingException {
        WorkItemDispatcher dispatcher = this.instantiateDispatcher(context, wi);
        if (wi instanceof InFlowItem) {
            InFlowItem ifi = (InFlowItem)wi;
            if (ifi.getParticipantName() == null) {
                ifi.setParticipantName(this.getRegex());
            }
            log.debug((Object)("dispatch() set participant name to >" + this.getRegex() + "< as it was missing."));
        }
        wi.touch();
        History history = Definitions.getHistory(context);
        if (wi instanceof InFlowWorkItem && history != null) {
            InFlowWorkItem ifwi = (InFlowWorkItem)wi;
            history.log(ifwi.getLastExpressionId(), ifwi, "+DIS", ifwi.getParticipantName(), this.getClass().getName());
        }
        return dispatcher.dispatch(wi);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

