/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.workitem;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ReflectionUtils;
import openwfe.org.engine.workitem.AtomicAttribute;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.Base64Attribute;
import openwfe.org.engine.workitem.BooleanAttribute;
import openwfe.org.engine.workitem.DoubleAttribute;
import openwfe.org.engine.workitem.IntegerAttribute;
import openwfe.org.engine.workitem.ListAttribute;
import openwfe.org.engine.workitem.LongAttribute;
import openwfe.org.engine.workitem.MapAttribute;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.engine.workitem.XmlAttribute;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;

public abstract class AttributeUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$workitem$AttributeUtils == null ? (class$openwfe$org$engine$workitem$AttributeUtils = AttributeUtils.class$("openwfe.org.engine.workitem.AttributeUtils")) : class$openwfe$org$engine$workitem$AttributeUtils).getName());
    private static final String A_BEAN_CLASSNAME = "__bean_classname__";
    static /* synthetic */ Class class$openwfe$org$engine$workitem$AttributeUtils;

    public static Object owfe2java(Attribute a) {
        StringMapAttribute sma;
        Attribute va;
        if (a instanceof AtomicAttribute) {
            return ((AtomicAttribute)a).getValue();
        }
        if (a instanceof StringMapAttribute && (va = (sma = (StringMapAttribute)a).get(A_BEAN_CLASSNAME)) != null && va instanceof StringAttribute) {
            return AttributeUtils.smap2bean(sma);
        }
        if (a instanceof MapAttribute) {
            return AttributeUtils.map2java((MapAttribute)a);
        }
        if (a instanceof ListAttribute) {
            return AttributeUtils.list2java((ListAttribute)a);
        }
        return "null";
    }

    private static Object smap2bean(StringMapAttribute sma) {
        String beanClassName = sma.sget(A_BEAN_CLASSNAME);
        Object bean = ReflectionUtils.buildNewInstance((String)beanClassName);
        Map fields = AttributeUtils.map2java(sma);
        Iterator it = fields.keySet().iterator();
        while (it.hasNext()) {
            String fieldName = (String)it.next();
            log.debug((Object)("smap2bean() fieldName >" + fieldName + "<"));
            if (fieldName.equals(A_BEAN_CLASSNAME)) continue;
            try {
                Class fieldClass = ReflectionUtils.getAttributeClass(bean.getClass(), (String)fieldName);
                log.debug((Object)("smap2bean() fieldClass is >" + fieldClass.getName() + "<"));
                Object fieldValue = null;
                if (fieldClass.isArray()) {
                    log.debug((Object)("smap2bean() '" + fieldName + "' is an array."));
                    fieldValue = AttributeUtils.toArray(fieldClass, (List)fields.get(fieldName));
                } else {
                    fieldValue = fields.get(fieldName);
                }
                ReflectionUtils.setAttribute((Object)bean, (String)fieldName, fieldValue);
            }
            catch (Exception e) {
                log.warn((Object)("smap2bean() bean of class '" + beanClassName + "' : failed to set value for field '" + fieldName + "'. Skipped field."));
                log.warn((Object)"because of", (Throwable)e);
            }
        }
        return bean;
    }

    private static Object toArray(Class arrayClass, List l) throws ClassNotFoundException {
        Class itemClass = ReflectionUtils.getItemClass((Class)arrayClass);
        log.debug((Object)("toArray() itemClass is " + itemClass.getName()));
        Object result = Array.newInstance(itemClass, l.size());
        for (int i = 0; i < l.size(); ++i) {
            Array.set(result, i, l.get(i));
        }
        return result;
    }

    public static Map map2java(MapAttribute ma) {
        HashMap<Object, Object> result = new HashMap<Object, Object>(ma.size());
        Iterator it = ma.keySet().iterator();
        while (it.hasNext()) {
            Attribute k = (Attribute)it.next();
            Attribute v = ma.get(k);
            result.put(AttributeUtils.owfe2java(k), AttributeUtils.owfe2java(v));
        }
        return result;
    }

    public static List list2java(ListAttribute la) {
        ArrayList<Object> result = new ArrayList<Object>(la.size());
        Iterator it = la.iterator();
        while (it.hasNext()) {
            Attribute v = (Attribute)it.next();
            result.add(AttributeUtils.owfe2java(v));
        }
        return result;
    }

    public static List owfe2list(Attribute a) {
        return AttributeUtils.owfe2list(a, ", *");
    }

    public static List owfe2list(Attribute a, String separator) {
        if (a instanceof ListAttribute) {
            ListAttribute la = (ListAttribute)a;
            ArrayList<String> result = new ArrayList<String>(la.size());
            Iterator it = la.iterator();
            while (it.hasNext()) {
                result.add(it.next().toString());
            }
            return result;
        }
        String s = "";
        if (a != null) {
            s = a.toString();
        }
        String[] ss = s.split(separator);
        ArrayList<String> result = new ArrayList<String>(ss.length);
        for (int i = 0; i < ss.length; ++i) {
            result.add(ss[i]);
        }
        return result;
    }

    public static Attribute java2owfe(Object o) {
        if (o == null) {
            return null;
        }
        log.debug((Object)("java2owfe() o.class is " + o.getClass().getName()));
        if (o instanceof Attribute) {
            return (Attribute)o;
        }
        if (o instanceof String) {
            return new StringAttribute((String)o);
        }
        if (o instanceof List) {
            return AttributeUtils.list2owfe((List)o);
        }
        if (o instanceof Map) {
            return AttributeUtils.map2owfe((Map)o);
        }
        if (o instanceof Integer) {
            return new IntegerAttribute((Integer)o);
        }
        if (o instanceof Long) {
            return new LongAttribute((Long)o);
        }
        if (o instanceof Double) {
            return new DoubleAttribute((Double)o);
        }
        if (o instanceof Boolean) {
            return new BooleanAttribute((Boolean)o);
        }
        if (o instanceof Content) {
            return new XmlAttribute((Content)o);
        }
        if (o instanceof Document) {
            return new XmlAttribute((Content)((Document)o).getRootElement());
        }
        if (o instanceof byte[]) {
            return Base64Attribute.newBase64Attribute((byte[])o);
        }
        if (o.getClass().isArray()) {
            return AttributeUtils.array2owfe(o);
        }
        if (ReflectionUtils.hasNoParamConstructor(o.getClass())) {
            return AttributeUtils.bean2owfe(o);
        }
        return new StringAttribute(o.toString());
    }

    private static ListAttribute array2owfe(Object array) {
        ListAttribute result = new ListAttribute(Array.getLength(array));
        for (int i = 0; i < Array.getLength(array); ++i) {
            result.add(AttributeUtils.java2owfe(Array.get(array, i)));
        }
        return result;
    }

    public static StringMapAttribute bean2owfe(Object o) {
        StringMapAttribute sma = new StringMapAttribute();
        sma.puts(A_BEAN_CLASSNAME, o.getClass().getName());
        Iterator it = ReflectionUtils.listReadWriteFields((Object)o).iterator();
        while (it.hasNext()) {
            AttributeUtils.resolveGet(sma, o, (Method[])it.next());
        }
        return sma;
    }

    private static void resolveGet(StringMapAttribute sma, Object bean, Method[] getAndSet) {
        try {
            Object value = getAndSet[0].invoke(bean, new Object[0]);
            String attributeName = getAndSet[0].getName().substring(3);
            Attribute aValue = AttributeUtils.java2owfe(value);
            if (aValue != null) {
                sma.put(attributeName, aValue);
            }
        }
        catch (Throwable t) {
            log.warn((Object)("resolveGet() failed to get value from " + getAndSet[0].getName() + "()"), t);
        }
    }

    public static ListAttribute list2owfe(List l) {
        ListAttribute result = new ListAttribute();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            result.add(AttributeUtils.java2owfe(it.next()));
        }
        return result;
    }

    public static MapAttribute map2owfe(Map m) {
        MapAttribute result = new MapAttribute();
        AttributeUtils.fillMap(result, m);
        return result;
    }

    public static StringMapAttribute java2attributes(Map m) {
        StringMapAttribute result = new StringMapAttribute();
        AttributeUtils.fillMap(result, m);
        return result;
    }

    private static void fillMap(MapAttribute ma, Map m) {
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            Object k = it.next();
            Object v = m.get(k);
            if (ma instanceof StringMapAttribute) {
                ma.put(new StringAttribute(k.toString()), AttributeUtils.java2owfe(v));
                continue;
            }
            ma.put(AttributeUtils.java2owfe(k), AttributeUtils.java2owfe(v));
        }
    }

    public static int toInt(ApplicationContext context, Attribute a) {
        Attribute a2;
        if (a == null) {
            throw new IllegalArgumentException("cannot turn a null attribute into an int");
        }
        log.debug((Object)("toInt() a.class is " + a.getClass().getName()));
        if (a instanceof XmlAttribute && (a2 = ((XmlAttribute)a).getAttributeContent(context)) != null) {
            a = a2;
        }
        if (a instanceof IntegerAttribute) {
            return ((IntegerAttribute)a).intValue();
        }
        return Integer.parseInt(a.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

