/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.engine.control.auth;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.HashMap;
import java.util.Map;
import openwfe.org.engine.control.auth.ControlPermissionCollection;
import org.apache.log4j.Logger;

public class ControlPermission
extends openwfe.org.auth.Permission {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$engine$control$auth$ControlPermission == null ? (class$openwfe$org$engine$control$auth$ControlPermission = ControlPermission.class$("openwfe.org.engine.control.auth.ControlPermission")) : class$openwfe$org$engine$control$auth$ControlPermission).getName());
    public static final String P_RIGHTS = "rights";
    public static final String P_ACTIONS = "actions";
    private static final int NONE = 0;
    private static final int READ = 1;
    private static final int FREEZE = 2;
    private static final int CANCEL = 4;
    private static final int ALL = 7;
    private static final String S_READ = "read";
    private static final String S_FREEZE = "freeze";
    private static final String S_CANCEL = "cancel";
    private int mask = 0;
    private transient String action = null;
    static /* synthetic */ Class class$openwfe$org$engine$control$auth$ControlPermission;

    public ControlPermission(Map params) {
        super(params);
        String actions = (String)params.get(P_RIGHTS);
        if (actions == null) {
            actions = (String)params.get(P_ACTIONS);
        }
        this.mask = ControlPermission.getMask(actions);
        this.action = null;
    }

    public static ControlPermission newControlPermission(String name, String actions) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("name", name);
        params.put(P_RIGHTS, actions);
        return new ControlPermission(params);
    }

    public int getMask() {
        return this.mask;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.mask;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ControlPermission)) {
            return false;
        }
        ControlPermission other = (ControlPermission)((Object)o);
        return this.mask == other.mask;
    }

    public boolean implies(Permission p) {
        if (p == null || !(p instanceof ControlPermission)) {
            return false;
        }
        ControlPermission sp = (ControlPermission)((Object)p);
        return (this.mask & sp.mask) == sp.mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new ControlPermissionCollection();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<ControlPermission name=\"");
        sb.append(this.getName());
        sb.append("\" actions=\"");
        if ((this.mask & 1) == 1) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if ((this.mask & 2) == 2) {
            sb.append('f');
        } else {
            sb.append('-');
        }
        if ((this.mask & 4) == 4) {
            sb.append('c');
        } else {
            sb.append('-');
        }
        sb.append("\" />");
        return sb.toString();
    }

    protected static String removeWildcard(String s) {
        if (s.length() < 1) {
            return ".";
        }
        if (!s.endsWith("*")) {
            return s + '!';
        }
        return s.substring(0, s.length() - 1);
    }

    public static boolean namesMatch(String n1, String n2) {
        n1 = ControlPermission.removeWildcard(n1);
        n2 = ControlPermission.removeWildcard(n2);
        return n2.startsWith(n1);
    }

    public static int getMask(String actions) {
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        String[] actionArray = actions.toLowerCase().split(",");
        for (int i = 0; i < actionArray.length; ++i) {
            String action = actionArray[i].trim();
            if (action.equals(S_READ)) {
                mask |= 1;
                continue;
            }
            if (action.equals(S_FREEZE)) {
                mask |= 2;
                continue;
            }
            if (!action.equals(S_CANCEL)) continue;
            mask |= 4;
        }
        return mask;
    }

    public String getActions() {
        if (this.action == null) {
            StringBuffer result = new StringBuffer();
            if ((this.mask & 1) == 1) {
                result.append(S_READ);
            }
            if ((this.mask & 2) == 2) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(S_FREEZE);
            }
            if ((this.mask & 4) == 4) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(S_CANCEL);
            }
            this.action = result.toString();
        }
        return this.action;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

